/*
 * Decompiled with CFR 0.152.
 */
package org.wooddog.mavenplugins.version;

import java.io.IOException;
import java.io.InputStream;
import org.wooddog.mavenplugins.version.exception.CommandLineInterfaceException;

public class InputStreamGobbler
extends Thread {
    private InputStream stream;
    private StringBuffer result;
    private boolean signal;
    private boolean running;

    public InputStreamGobbler(InputStream inputStream) {
        this.stream = inputStream;
    }

    @Override
    public synchronized void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.signal = false;
        super.start();
    }

    @Override
    public void run() {
        byte[] buffer = new byte[4096];
        this.result = new StringBuffer();
        try {
            while (!this.signal) {
                int length = this.stream.read(buffer);
                if (length == -1) {
                    InputStreamGobbler.sleep(250L);
                    continue;
                }
                this.result.append(new String(buffer, 0, length));
            }
        }
        catch (IOException x) {
            throw new CommandLineInterfaceException("unable to read stream", x);
        }
        catch (InterruptedException x) {
            throw new CommandLineInterfaceException("thread killed", x);
        }
        this.running = false;
    }

    public void kill() throws InterruptedException {
        this.signal = true;
        while (this.running) {
            InputStreamGobbler.sleep(250L);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public String getResult() {
        return this.result.toString();
    }
}

