/*
 * Decompiled with CFR 0.152.
 */
package org.wooddog.mavenplugins.version.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.wooddog.mavenplugins:version:0.1", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven Version Plugin 0.1", 0);
        this.append(sb, "Maintains release branches, tags and project version.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 6 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "version:help", 0);
            this.append(sb, "Display help information on version.\nCall\n\u00a0\u00a0mvn\u00a0version:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "merge".equals(this.goal)) {
            this.append(sb, "version:merge", 0);
            this.append(sb, "This goal merges changes since the last merge from the current release branch to the main branch.\nThe local repository needs to be up to date and mirror the main branch, if the goal is executed on any other branch or the local source files are out of date, a mojo failure exception is thrown.\n\nIf some files contains conflicts after the merge, a mojo failure exception is thrown and the files need to be resolved manually. After all files has been resolved rerun this goal and if no other conflicts has been introduced mean while the merge will complete and be committed.\n\nPeople can still use the server repository while merging as a fixed change set is calculated at start and used through out the merge, but in a high traffic repository it may take several attempts to resolve conflicts as new may be introduced while fixing the one from the previous attempt.\n\nTo clear a merge and start all over, run svn revert in the root folder of the project, this will rollback all the files and reset the merge point.\n\nTo avoid the version number from the branch be submitted to trunk, the version number is replaced with initial value before the merge.\n\nIf a manually merge has been done for some reason, a new merge point can be set by running the goal set-merge-point see goal for details.\n\nNOTE if you want to merge a branch which was not created by version:promote you need to set an initial merge point with version:set-merge-point\n", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "Instance to the running Maven project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "properties", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "values", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "promote".equals(this.goal)) {
            this.append(sb, "version:promote", 0);
            this.append(sb, "This goal promotes the source code by increasing the version number and creating the respective branch and tag.\nThe local repository must be an exact copy of an existing revision in the server repository, it does not have to be the latest revision, but it need to be a newer revision than the last promotion. If one of these conditions is not met a mojo failure exception is thrown\n\nPromoting source code in the main branch will result in:\n\n-\tVersion in main branch is increased to X.(Y+1)-SNAPSHOT\n-\tBranch created with version number X.Y.1-SNAPSHOT\n-\tTag created with version number X.Y.0\n-\tMerge starting point set.\n\n\n\nPromoting source code in the release branch will result in:\n\n-\tVersion in the release branch is increased to X.Y.(Z+1)-SNAPSHOT\n-\tTag created with version number X.Y.Z\n\n\n\nTo increase the version number manually simple change the version number in the pom file of the main branch, merge and other goals of this package will respect such a change and pick up the new version number.\n", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "Instance to the running Maven project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "properties", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "values", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "set-merge-point".equals(this.goal)) {
            this.append(sb, "version:set-merge-point", 0);
            this.append(sb, "This goal sets a new merge point.\nSometimes it is desirable to be able to manipulate the starting point of the next merge, that could be if one accidental commits to the release branch instead of the main branch. In cases like this the changes could be merged to main branch, then rolled back on the release branch and then a new merge point set so the rollback is not merged down next time merge is run.\n\nMerge points can only be set on the main branch.\n\nTo set a new merge point run version:set-merge-point -Drevision=xxx\n", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "Instance to the running Maven project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "properties", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "revision", 2);
                this.append(sb, "Instance to the running Maven project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "values", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "switch".equals(this.goal)) {
            this.append(sb, "version:switch", 0);
            this.append(sb, "This goal switches the local repository between branches and tags.\nTo switch the local repository to one of the below versions, simple run\nversion:switch -Dversion=release\nPossible branches and tags to switch to\n\nVersion\nDescription\nbranch\nSwitch source code to the latest release branch\n\n\nmain\nSwitch source code to the main branch\n\n\nrelease\nSwitch source code to the latest release\nX.Y.Z\nSwitch source code to a the given release", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "Instance to the running Maven project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "properties", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "values", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "version", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "uptodate-check".equals(this.goal)) {
            this.append(sb, "version:uptodate-check", 0);
            this.append(sb, "This goal checks that the local repository is an exact copy of an existing revision.\nIf the check fails a mojo failure exception is thrown.\n", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "Instance to the running Maven project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "properties", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "values", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

