/*
 * Decompiled with CFR 0.152.
 */
package org.wooddog.mavenplugins.version.plugin;

import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.wooddog.mavenplugins.version.Pom;
import org.wooddog.mavenplugins.version.SubversionUrl;
import org.wooddog.mavenplugins.version.SvnUtil;
import org.wooddog.mavenplugins.version.Version;
import org.wooddog.mavenplugins.version.exception.BadBranchVersionException;
import org.wooddog.mavenplugins.version.exception.CommitException;
import org.wooddog.mavenplugins.version.exception.ConflictException;
import org.wooddog.mavenplugins.version.exception.DirtyRepositoryException;
import org.wooddog.mavenplugins.version.plugin.AbstractVersionMojo;

public class MergeMojo
extends AbstractVersionMojo {
    private SvnUtil svn = new SvnUtil();

    @Override
    protected void run() throws MojoFailureException, MojoExecutionException {
        String log = this.svn.update("-N", ".");
        String revision = this.svn.getValue(log, "^At revision (\\d+)\\.$");
        if (revision == null) {
            throw new MojoFailureException("no revision found of repo, " + log);
        }
        if (!this.getProjectVersion().isMainBranch()) {
            throw new BadBranchVersionException("unable to merge local mirror, please switch to main branch");
        }
        String version = this.svn.propget("org.wooddog:merging", ".");
        if (version.isEmpty()) {
            version = this.getVersionFormatter().format(this.getProjectVersion());
            log = this.svn.status(".");
            if (!(log = this.svn.filterLog(log, "ACDMR!~")).isEmpty()) {
                this.getLog().error((CharSequence)("dirty files found in local repo:\n" + log));
                throw new DirtyRepositoryException("local mirror is dirty");
            }
            List<Version> versionList = this.svn.listVersions(this.getBranchBaseUrl(), this.getBranchFormatter(), this.getBranchFilter());
            if (versionList.isEmpty()) {
                throw new BadBranchVersionException("no branches found");
            }
            Version latestVersion = versionList.get(0);
            this.getLog().info((CharSequence)("merging changes from " + this.getBranchFormatter().format(latestVersion)));
            String start = this.svn.propget("org.wooddog:merged", ".");
            String end = revision;
            SubversionUrl url = new SubversionUrl(this.getBranchBaseUrl(), this.getBranchFormatter().format(latestVersion));
            log = this.svn.merge("--accept", "postpone", "-r", start + ":" + end, url.getUrl());
            this.svn.propset("org.wooddog:merging", this.getVersionFormatter().format(this.getProjectVersion()), ".");
            this.svn.propset("org.wooddog:merged", end, ".");
        } else {
            this.getLog().info((CharSequence)("resuming merge of " + this.getBranchFormatter().format(this.getVersionFormatter().parse(version))));
            log = this.svn.status(".");
        }
        log = this.svn.filterLog(log, "C");
        if (!log.isEmpty()) {
            this.getLog().error((CharSequence)("files in conflict:\n" + log));
            throw new ConflictException("merge could not complete because of conflicts");
        }
        this.svn.propdel("org.wooddog:merging", ".");
        try {
            Pom.getInstance().writeVersion(this.getVersionFormatter().parse(version));
            this.svn.commit("-m", this.getMergeMessage(), ".");
        }
        catch (Throwable x) {
            x.printStackTrace();
            this.svn.propset("org.wooddog:merging", version, ".");
            throw new CommitException("unable to commit merge, " + x.getMessage());
        }
        this.getLog().info((CharSequence)"merge completed");
    }
}

