/*
 * Decompiled with CFR 0.152.
 */
package org.wooddog.mavenplugins.version.plugin;

import java.util.List;
import java.util.logging.Logger;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.wooddog.mavenplugins.version.SubversionUrl;
import org.wooddog.mavenplugins.version.SvnUtil;
import org.wooddog.mavenplugins.version.Version;
import org.wooddog.mavenplugins.version.exception.BadBranchVersionException;
import org.wooddog.mavenplugins.version.exception.VersionParseException;
import org.wooddog.mavenplugins.version.plugin.AbstractVersionMojo;

public class SwitchMojo
extends AbstractVersionMojo {
    private static final Logger LOGGER = Logger.getLogger(SwitchMojo.class.getName());
    private String version;

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public void run() throws MojoFailureException, MojoExecutionException {
        Version tmpVersion;
        SvnUtil svn = new SvnUtil();
        if ("release".equals(this.version)) {
            List<Version> versionList = svn.listVersions(this.getReleaseBaseUrl(), this.getReleaseFormatter(), this.getReleaseFilter());
            if (versionList.isEmpty()) {
                throw new BadBranchVersionException("no release tags found");
            }
            SubversionUrl url = new SubversionUrl(this.getReleaseBaseUrl(), this.getReleaseFormatter().format(versionList.get(0)));
            svn.change(url.getUrl());
            this.getLog().info((CharSequence)("local repo switched to " + url.getName()));
            return;
        }
        if ("branch".equals(this.version)) {
            List<Version> versionList = svn.listVersions(this.getBranchBaseUrl(), this.getBranchFormatter(), this.getBranchFilter());
            if (versionList.isEmpty()) {
                throw new BadBranchVersionException("no release branches found");
            }
            SubversionUrl url = new SubversionUrl(this.getBranchBaseUrl(), this.getBranchFormatter().format(versionList.get(0)));
            svn.change(url.getUrl());
            this.getLog().info((CharSequence)("local repo switched to " + url.getName()));
            return;
        }
        if ("main".equals(this.version)) {
            svn.change(this.getMainBaseUrl().getUrl());
            this.getLog().info((CharSequence)("local repo switched to " + this.getMainBaseUrl().getName()));
            return;
        }
        try {
            tmpVersion = this.getVersionFormatter().parse(this.version);
        }
        catch (VersionParseException x) {
            throw new MojoFailureException(this.version + " is not a valid version");
        }
        SubversionUrl url = tmpVersion.isSnapShot() ? new SubversionUrl(this.getBranchBaseUrl(), this.getBranchFormatter().format(tmpVersion)) : new SubversionUrl(this.getReleaseBaseUrl(), this.getReleaseFormatter().format(tmpVersion));
        svn.change(url.getUrl());
        this.getLog().info((CharSequence)("local repository switched to " + url.getName()));
    }
}

