/*
 * Decompiled with CFR 0.152.
 */
package org.wooddog.mavenplugins.version;

import org.wooddog.mavenplugins.version.Version;
import org.wooddog.mavenplugins.version.exception.VersionParseException;

public class VersionFormatter {
    private String pattern;

    public VersionFormatter(String pattern) {
        this.pattern = pattern;
    }

    public Version parse(String version) throws VersionParseException {
        return new Parser(this.pattern, version).parse();
    }

    public String format(Version version) {
        return new Formatter(this.pattern, version).format();
    }

    private class Parser {
        private String pattern;
        private int patternPos;
        private int sourcePos;
        private StringBuffer buffer;
        String value;

        public Parser(String pattern, String value) {
            this.pattern = pattern;
            this.value = value;
            this.buffer = new StringBuffer();
        }

        public Version parse() throws VersionParseException {
            boolean strict = true;
            while (this.patternPos < this.pattern.length()) {
                if (this.pattern.charAt(this.patternPos) == '#') {
                    if (this.isNextChar('{')) {
                        this.patternPos += 2;
                        this.translate();
                        continue;
                    }
                    while (this.sourcePos < this.value.length() && this.value.charAt(this.sourcePos) >= '0' && this.value.charAt(this.sourcePos) <= '9') {
                        this.buffer.append(this.value.charAt(this.sourcePos++));
                    }
                    this.buffer.append(".");
                    ++this.patternPos;
                    continue;
                }
                if (this.pattern.charAt(this.patternPos) == '(') {
                    strict = false;
                    ++this.patternPos;
                    continue;
                }
                if (this.pattern.charAt(this.patternPos) == ')') {
                    if (this.isNextChar('*')) {
                        this.patternPos = this.pattern.substring(0, this.patternPos).lastIndexOf(40);
                        strict = true;
                        continue;
                    }
                    strict = true;
                    ++this.patternPos;
                    continue;
                }
                if (this.sourcePos >= this.value.length() || this.value.charAt(this.sourcePos) != this.pattern.charAt(this.patternPos)) {
                    if (!strict) {
                        this.sourcePos -= this.patternPos - this.pattern.substring(0, this.patternPos).lastIndexOf(40) - 1;
                        this.patternPos = this.pattern.indexOf(41, this.patternPos) + 1;
                        if (this.patternPos < this.pattern.length() && this.pattern.charAt(this.patternPos) == '*') {
                            ++this.patternPos;
                        }
                        if (this.sourcePos < this.value.length()) {
                            // empty if block
                        }
                        if (this.patternPos >= this.pattern.length()) continue;
                        continue;
                    }
                    throw new VersionParseException("unable to parse " + this.buffer.toString() + " " + this.value);
                }
                ++this.patternPos;
                ++this.sourcePos;
            }
            this.buffer.deleteCharAt(this.buffer.length() - 1);
            return Version.valueOf(this.buffer.toString());
        }

        private void translate() throws VersionParseException {
            StringBuffer translationNumber = new StringBuffer();
            while (this.pattern.charAt(this.patternPos) != ':') {
                if (this.isPatternCharNumber()) {
                    translationNumber.append(this.pattern.charAt(this.patternPos));
                    ++this.patternPos;
                    continue;
                }
                throw new VersionParseException("error in pattern at index " + this.patternPos + " expected a number but found " + this.pattern.charAt(this.patternPos));
            }
            ++this.patternPos;
            int sourceMark = this.sourcePos;
            while (this.sourcePos < this.value.length() && this.pattern.charAt(this.patternPos) == this.value.charAt(this.sourcePos)) {
                ++this.patternPos;
                ++this.sourcePos;
            }
            if (this.pattern.charAt(this.patternPos) == ',' || this.pattern.charAt(this.patternPos) == '}') {
                this.buffer.append(translationNumber);
                this.buffer.append(".");
                while (this.pattern.charAt(this.patternPos) != '}') {
                    ++this.patternPos;
                }
                ++this.patternPos;
            } else {
                this.sourcePos = sourceMark;
                while (this.pattern.charAt(this.patternPos) != ',' && this.pattern.charAt(this.patternPos) != '}') {
                    ++this.patternPos;
                }
                if (this.pattern.charAt(this.patternPos) == '}') {
                    throw new VersionParseException("no translation value found for source position " + sourceMark + " search ended at pattern position " + this.patternPos);
                }
                ++this.patternPos;
                this.translate();
            }
        }

        boolean isPatternCharNumber() {
            return this.pattern.charAt(this.patternPos) >= '0' && this.pattern.charAt(this.patternPos) <= '9';
        }

        private boolean isNextChar(char c) {
            return this.patternPos + 1 < this.pattern.length() && this.pattern.charAt(this.patternPos + 1) == c;
        }
    }

    private class Formatter {
        private Version version;
        private String pattern;

        private Formatter(String pattern, Version version) {
            this.version = version;
            this.pattern = pattern;
        }

        public String format() {
            int[] digits = this.version.getVersion();
            boolean skip = false;
            StringBuffer buffer = new StringBuffer();
            int index = 0;
            for (int patternPos = 0; patternPos < this.pattern.length(); ++patternPos) {
                if (this.pattern.charAt(patternPos) == ')') {
                    skip = false;
                    if (!this.isNextChar(patternPos, '*')) continue;
                    if (index == digits.length - 1) {
                        ++patternPos;
                        continue;
                    }
                    patternPos = this.pattern.substring(0, patternPos).lastIndexOf(40) - 1;
                    continue;
                }
                if (this.pattern.charAt(patternPos) == '(') {
                    if (this.remaining(patternPos) < digits.length - index) continue;
                    skip = true;
                    continue;
                }
                if (skip) continue;
                if (this.pattern.charAt(patternPos) == '#') {
                    if (this.isNextChar(patternPos, '{')) {
                        patternPos = this.translate(buffer, patternPos, digits[index]);
                        continue;
                    }
                    buffer.append(Integer.toString(digits[index++]));
                    continue;
                }
                buffer.append(this.pattern.charAt(patternPos));
            }
            return buffer.toString();
        }

        private boolean isNextChar(int patternPos, char c) {
            return patternPos + 1 < this.pattern.length() && this.pattern.charAt(patternPos + 1) == c;
        }

        private int translate(StringBuffer buffer, int position, int digit) {
            int matched = 0;
            boolean skip = true;
            String value = Integer.toString(digit);
            int pos = position;
            while (this.pattern.charAt(pos) != '}') {
                if (this.pattern.charAt(pos) == ':' && matched == value.length()) {
                    skip = false;
                } else if (this.pattern.charAt(pos) == ',') {
                    matched = 0;
                    skip = true;
                } else if (skip) {
                    matched = value.length() > matched && this.pattern.charAt(pos) == value.charAt(matched) ? ++matched : 0;
                } else {
                    buffer.append(this.pattern.charAt(pos));
                }
                ++pos;
            }
            return pos;
        }

        private int remaining(int position) {
            int remaining = 0;
            boolean skip = false;
            for (int i = position; i < this.pattern.length(); ++i) {
                if (this.pattern.charAt(i) == ')') {
                    skip = false;
                    continue;
                }
                if (this.pattern.charAt(i) == '(') {
                    skip = true;
                    continue;
                }
                if (skip || this.pattern.charAt(i) != '#') continue;
                ++remaining;
            }
            return remaining;
        }
    }
}

