/*
 * Decompiled with CFR 0.152.
 */
package org.wooddog.mavenplugins.version;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Config {
    private static final Config INSTANCE = new Config();
    private Map<String, Object> values = new HashMap<String, Object>();

    public static Config getInstance() {
        return INSTANCE;
    }

    private Config() {
    }

    public void add(String key, Object value) {
        this.values.put(key, value);
    }

    public void addAll(Map map) {
        for (Object key : map.keySet()) {
            this.add(key.toString(), map.get(key));
        }
    }

    public String get(String key) {
        String rootKey;
        Object value = null;
        if (this.values.containsKey(key)) {
            value = this.values.get(key);
        } else if (key.indexOf(".") != -1 && this.values.containsKey(rootKey = key.substring(0, key.indexOf(".")))) {
            value = this.resolve(key.substring(rootKey.length() + 1), this.values.get(rootKey));
        }
        if (value != null) {
            value = this.evaluate(this.toString(value));
        }
        return (String)value;
    }

    public void load(String resource) {
        InputStream resourceStream = this.getClass().getClassLoader().getResourceAsStream(resource);
        if (resourceStream == null) {
            throw new IllegalArgumentException("unable to find configuration " + resource + " in classpath");
        }
        Properties properties = new Properties();
        try {
            properties.load(resourceStream);
        }
        catch (IOException x) {
            throw new IllegalStateException("unable to load configuration " + resource + " msg: " + x.getMessage(), x);
        }
        this.addAll(properties);
    }

    private Object resolve(String property, Object object) {
        if (object instanceof Map) {
            return ((Map)object).get(property);
        }
        if (property.indexOf(".") == -1) {
            return this.getPropertyValue(property, object);
        }
        String rootProperty = property.substring(0, property.indexOf("."));
        String subProperty = property.substring(rootProperty.length() + 1);
        return this.resolve(subProperty, this.getPropertyValue(rootProperty, object));
    }

    private String evaluate(String value) {
        Pattern pattern = Pattern.compile("(\\$\\{([\\w\\.]+)\\})");
        Matcher matcher = pattern.matcher(value);
        StringBuffer result = new StringBuffer();
        int pos = 0;
        while (matcher.find()) {
            result.append(value.substring(pos, matcher.start(1)));
            result.append(this.get(matcher.group(2)));
            pos = matcher.end(1);
        }
        result.append(value.substring(pos));
        return result.toString();
    }

    private String toString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    private Object getPropertyValue(String property, Object object) {
        Object value;
        String methodName = "get" + property.substring(0, 1).toUpperCase() + property.substring(1);
        try {
            Method method = object.getClass().getMethod(methodName, new Class[0]);
            value = method.invoke(object, new Object[0]);
        }
        catch (NoSuchMethodException x) {
            x.printStackTrace();
            throw new RuntimeException(x);
        }
        catch (IllegalAccessException x) {
            x.printStackTrace();
            throw new RuntimeException(x);
        }
        catch (InvocationTargetException x) {
            x.printStackTrace();
            throw new RuntimeException(x);
        }
        return value;
    }
}

