/*
 * Decompiled with CFR 0.152.
 */
package org.wooddog.mavenplugins.version;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.wooddog.mavenplugins.version.Config;
import org.wooddog.mavenplugins.version.Version;
import org.wooddog.mavenplugins.version.VersionFormatter;
import org.wooddog.mavenplugins.version.exception.PomInstantiationException;
import org.wooddog.mavenplugins.version.exception.VersionLoadException;
import org.wooddog.mavenplugins.version.exception.VersionParseException;
import org.wooddog.mavenplugins.version.exception.VersionSaveException;

public class Pom {
    public static final String CFG_POM_IMPLEMENTATION = "org.wooddog.mavenplugins.version.pom.implementation";
    private static final Pom INSTANCE = Pom.newInstance();

    protected Pom() {
    }

    private static Pom newInstance() throws PomInstantiationException {
        Pom pom;
        String pomImpl = Config.getInstance().get(CFG_POM_IMPLEMENTATION);
        if (pomImpl == null) {
            return new Pom();
        }
        try {
            pom = (Pom)Class.forName(pomImpl).newInstance();
        }
        catch (ClassNotFoundException x) {
            throw new PomInstantiationException("unable to find pom implementation " + pomImpl, x);
        }
        catch (IllegalAccessException x) {
            throw new PomInstantiationException("pom implementation " + pomImpl + " has no accessable constructor", x);
        }
        catch (InstantiationException x) {
            throw new PomInstantiationException("instantiating pom implementation " + pomImpl + " caused " + x.getMessage(), x);
        }
        return pom;
    }

    public static Pom getInstance() {
        return INSTANCE;
    }

    public void save(Document document) throws VersionSaveException {
        File file = new File("pom.xml");
        try {
            XMLWriter writer = new XMLWriter((OutputStream)new FileOutputStream(new File("pom.xml")));
            writer.write(document);
        }
        catch (FileNotFoundException x) {
            throw new VersionSaveException("pom file " + file.getAbsolutePath() + " is not accesable, " + x.getMessage());
        }
        catch (IOException x) {
            throw new VersionSaveException("unable to save " + file.getAbsolutePath() + ", " + x.getMessage());
        }
    }

    public Document load() throws VersionLoadException {
        Document document;
        File file = new File("pom.xml");
        try {
            SAXReader reader = new SAXReader();
            document = reader.read("pom.xml");
        }
        catch (DocumentException x) {
            throw new VersionLoadException("unable to load " + file.getAbsolutePath() + ", " + x.getMessage());
        }
        return document;
    }

    public void writeVersion(Version version) throws VersionLoadException, VersionSaveException {
        VersionFormatter formatter = new VersionFormatter(Config.getInstance().get("version.format"));
        Document document = this.load();
        document.getRootElement().element("version").setText(formatter.format(version));
        this.save(document);
    }

    public Version readVersion() throws VersionLoadException, VersionParseException {
        VersionFormatter formatter = new VersionFormatter(Config.getInstance().get("version.format"));
        Document document = this.load();
        String version = document.getRootElement().element("version").getText();
        return formatter.parse(version);
    }

    public Version readVersion(String pom) throws VersionLoadException, VersionParseException {
        Document document;
        VersionFormatter formatter = new VersionFormatter(Config.getInstance().get("version.format"));
        try {
            document = DocumentHelper.parseText((String)pom);
        }
        catch (DocumentException x) {
            throw new VersionLoadException("pom is not valid xml, " + x.getMessage());
        }
        String version = document.getRootElement().element("version").getText();
        return formatter.parse(version);
    }
}

