/*
 * Decompiled with CFR 0.152.
 */
package org.wooddog.mavenplugins.version;

public class SubversionUrl {
    private String base;
    private String path;

    public SubversionUrl(String base, String path) {
        this.base = this.strip(base);
        if (path != null) {
            this.path = "/" + this.strip(path);
        }
    }

    public SubversionUrl(String base) {
        this(base, null);
    }

    public SubversionUrl(SubversionUrl url, String path) {
        this(url.getUrl(), path);
    }

    public String getBase() {
        return this.base;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.path == null ? this.base.substring(this.base.lastIndexOf("/") + 1) : this.path.substring(this.path.lastIndexOf("/") + 1);
    }

    public String getUrl() {
        return this.path == null ? this.base : this.base + this.path;
    }

    private String strip(String value) {
        String str = value.trim();
        if (str.endsWith("/")) {
            str = str.substring(0, str.length() - 1);
        }
        if (str.startsWith("/")) {
            str = str.substring(1);
        }
        return str;
    }
}

