/*
 * Decompiled with CFR 0.152.
 */
package org.wooddog.mavenplugins.version;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoFailureException;
import org.wooddog.mavenplugins.version.CommandLineInterface;
import org.wooddog.mavenplugins.version.Config;
import org.wooddog.mavenplugins.version.Filter;
import org.wooddog.mavenplugins.version.Message;
import org.wooddog.mavenplugins.version.SubversionUrl;
import org.wooddog.mavenplugins.version.Version;
import org.wooddog.mavenplugins.version.VersionFormatter;
import org.wooddog.mavenplugins.version.exception.CommitException;
import org.wooddog.mavenplugins.version.exception.VersionParseException;

public class SvnUtil {
    public String log(String ... args) throws MojoFailureException {
        String log = this.execute("log", args);
        return log;
    }

    public String info(String args) throws MojoFailureException {
        String log = this.execute("info", args);
        return log;
    }

    public String change(String args) throws MojoFailureException {
        String log = this.execute("switch", args);
        return log;
    }

    public String merge(String ... args) throws MojoFailureException {
        String log = this.execute("merge", args);
        return log;
    }

    public String propdel(String ... args) throws MojoFailureException {
        String log = this.execute("propdel", args);
        return log;
    }

    public String info(String ... args) throws MojoFailureException {
        String log = this.execute("info", args);
        return log;
    }

    public String propget(String ... args) throws MojoFailureException {
        String log = this.execute("propget", args);
        return log;
    }

    public String propset(String ... args) throws MojoFailureException {
        String log = this.execute("propset", args);
        return log;
    }

    public String list(String ... args) throws MojoFailureException {
        String log = this.execute("list", args);
        return log;
    }

    public String update(String ... args) throws MojoFailureException {
        String log = this.execute("update", args);
        return log;
    }

    public String status(String ... args) throws MojoFailureException {
        String log = this.execute("status", args);
        return log;
    }

    public String commit(String ... args) throws MojoFailureException {
        if ("true".equals(Config.getInstance().get("commit"))) {
            return "";
        }
        String log = this.execute("commit", args);
        Pattern pattern = Pattern.compile("Committed revision \\d+\\.", 8);
        Matcher matcher = pattern.matcher(log);
        if (!matcher.find()) {
            throw new CommitException("failed commiting file");
        }
        return log;
    }

    public String diff(String ... args) throws MojoFailureException {
        String log = this.execute("diff", args);
        return log;
    }

    public String copy(String ... args) throws MojoFailureException {
        if ("true".equals(Config.getInstance().get("commit"))) {
            return "0";
        }
        String log = this.execute("copy", args);
        Pattern pattern = Pattern.compile("Committed revision (\\d+)\\.");
        Matcher matcher = pattern.matcher(log);
        if (!matcher.find()) {
            throw new CommitException("unable to commit copy, " + log);
        }
        return matcher.group(1);
    }

    private String execute(String command, String ... args) throws MojoFailureException {
        String[] arguments = new String[args.length + 2];
        arguments[0] = "svn";
        arguments[1] = command;
        System.arraycopy(args, 0, arguments, 2, args.length);
        Message message = CommandLineInterface.getCommandLineInterface().execute(arguments);
        if (message.getStatus() != 0) {
            throw new MojoFailureException("error executing " + command + ", " + message.getMessage());
        }
        return message.getMessage().trim();
    }

    public List<Version> listVersions(SubversionUrl url, VersionFormatter formatter, Filter<SubversionUrl> filter) throws MojoFailureException {
        ArrayList<Version> versionList = new ArrayList<Version>();
        String log = this.list(url.getUrl());
        StringTokenizer tokenizer = new StringTokenizer(log, "\n", false);
        while (tokenizer.hasMoreElements()) {
            SubversionUrl tmpUrl = new SubversionUrl(url, tokenizer.nextToken());
            if (!filter.accept(tmpUrl)) continue;
            try {
                versionList.add(formatter.parse(tmpUrl.getName().trim()));
            }
            catch (VersionParseException x) {
                throw new MojoFailureException("unable parse version of " + tmpUrl);
            }
        }
        Collections.sort(versionList);
        Collections.reverse(versionList);
        return versionList;
    }

    public boolean hasLine(String line, CharSequence states) {
        if (line.isEmpty()) {
            return false;
        }
        for (int i = 0; i < states.length(); ++i) {
            if (line.charAt(0) != states.charAt(i)) continue;
            return true;
        }
        return false;
    }

    public String filterLog(String log, String state) {
        String[] lines;
        StringBuffer filteredLog = new StringBuffer();
        for (String line : lines = log.split("\n")) {
            if (!this.hasLine(line, state)) continue;
            filteredLog.append(line + "\n");
        }
        return filteredLog.toString();
    }

    public String getValue(String log, String regexp) {
        Pattern pattern = Pattern.compile(regexp, 8);
        Matcher matcher = pattern.matcher(log);
        return matcher.find() ? matcher.group(1) : null;
    }
}

