/*
 * Decompiled with CFR 0.152.
 */
package org.wooddog.mavenplugins.version;

public class Version
implements Comparable {
    public static final int SNAPSHOT = 0;
    public static final int RELEASE = 1;
    private int[] digits;

    public Version(int ... version) {
        this.digits = version;
    }

    public int[] getVersion() {
        return this.digits;
    }

    public void promote() {
        int n = this.digits.length - 2;
        this.digits[n] = this.digits[n] + 1;
    }

    public void demote() {
        int n = this.digits.length - 2;
        this.digits[n] = this.digits[n] - 1;
    }

    public boolean isSnapShot() {
        return this.digits[this.digits.length - 1] == 0;
    }

    public void setSnapShot(boolean flag) {
        this.digits[this.digits.length - 1] = flag ? 0 : 1;
    }

    public boolean isMainBranch() {
        return this.digits.length == 3 && this.isSnapShot();
    }

    public boolean isReleaseBranch() {
        return this.digits.length == 4 && this.isSnapShot();
    }

    public int compareTo(Object o) {
        Version version = (Version)o;
        int length = this.digits.length < version.digits.length ? this.digits.length : version.digits.length;
        for (int i = 0; i < length; ++i) {
            if (this.digits[i] < version.digits[i]) {
                return -1;
            }
            if (this.digits[i] <= version.digits[i]) continue;
            return 1;
        }
        if (this.digits.length > version.digits.length) {
            return -1;
        }
        if (this.digits.length < version.digits.length) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        String value = "";
        for (int digit : this.digits) {
            value = value + "." + digit;
        }
        return value.substring(1);
    }

    public static Version valueOf(String value) {
        String[] values = value.split("\\.");
        int[] digits = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            digits[i] = Integer.parseInt(values[i]);
        }
        return new Version(digits);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Version)) {
            return false;
        }
        Version v = (Version)obj;
        if (this.digits.length != v.digits.length) {
            return false;
        }
        for (int i = 0; i < v.digits.length; ++i) {
            if (this.digits[i] == v.digits[i]) continue;
            return false;
        }
        return true;
    }
}

