/*
 * Decompiled with CFR 0.152.
 */
package org.wooddog.mavenplugins.version.plugin;

import java.util.Map;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.wooddog.mavenplugins.version.CommandLineInterface;
import org.wooddog.mavenplugins.version.Config;
import org.wooddog.mavenplugins.version.Filter;
import org.wooddog.mavenplugins.version.SubversionUrl;
import org.wooddog.mavenplugins.version.SvnUtil;
import org.wooddog.mavenplugins.version.Version;
import org.wooddog.mavenplugins.version.VersionFormatter;
import org.wooddog.mavenplugins.version.exception.VersionParseException;

public abstract class AbstractVersionMojo
extends AbstractMojo {
    private static final String CONFIG_SVN_ROOT = "svn.root";
    private static final String CONFIG_MAIN_BASE = "svn.main";
    private static final String CONFIG_BRANCH_BASE = "svn.branch";
    private static final String CONFIG_RELEASE_BASE = "svn.release";
    private static final String CONFIG_SVN_REVISION = "svn.revision";
    private static final String CONFIG_BRANCH_FILTER = "branch.filter";
    private static final String CONFIG_BRANCH_PATTERN = "branch.pattern";
    private static final String CONFIG_BRANCH_MESSAGE = "branch.message";
    private static final String CONFIG_RELEASE_FILTER = "release.filter";
    private static final String CONFIG_RELEASE_PATTERN = "release.pattern";
    private static final String CONFIG_RELEASE_MESSAGE = "release.message";
    private static final String CONFIG_MERGE_MESSAGE = "merge.message";
    private static final String CONFIG_VERSION_FORMAT = "version.format";
    private static final String CONFIG_KEEP_LOG = "cli.keeplog";
    private static final String CONFIG_MERGE_MODE = "merge.mode";
    private Config config = Config.getInstance();
    private Map<String, String> values;
    private String properties;
    private MavenProject project;

    protected abstract void run() throws MojoExecutionException, MojoFailureException;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        Config config = Config.getInstance();
        config.addAll(System.getProperties());
        if (this.properties == null) {
            config.load("org/wooddog/mavenplugins/version/config/default.properties");
        } else {
            config.load(this.properties);
        }
        if (this.values != null) {
            config.addAll(this.values);
        }
        SvnUtil svn = new SvnUtil();
        String log = svn.info(".");
        config.add(CONFIG_SVN_ROOT, svn.getValue(log, "^Repository Root: (.+)$"));
        if ("true".equals(Config.getInstance().get("commit"))) {
            this.getLog().info((CharSequence)"commits are turned off");
        }
        if (this.project != null) {
            config.add("project", this.project);
        }
        this.run();
        if (!"true".equals(config.get(CONFIG_KEEP_LOG))) {
            CommandLineInterface.getCommandLineInterface().deleteLog();
        }
    }

    protected Version getProjectVersion() throws MojoFailureException {
        Version version;
        try {
            version = this.getVersionFormatter().parse(Config.getInstance().get("project.version"));
        }
        catch (VersionParseException x) {
            throw new MojoFailureException("unable to parse project version, " + x.getMessage());
        }
        return version;
    }

    protected VersionFormatter getBranchFormatter() {
        return new VersionFormatter(this.config.get(CONFIG_BRANCH_PATTERN));
    }

    protected Filter<SubversionUrl> getBranchFilter() {
        return new BranchFilter();
    }

    protected SubversionUrl getBranchBaseUrl() {
        return new SubversionUrl(this.config.get(CONFIG_BRANCH_BASE));
    }

    protected String getBranchMessage() {
        return this.config.get(CONFIG_BRANCH_MESSAGE);
    }

    protected VersionFormatter getReleaseFormatter() {
        return new VersionFormatter(this.config.get(CONFIG_RELEASE_PATTERN));
    }

    protected Filter<SubversionUrl> getReleaseFilter() {
        return new ReleaseFilter();
    }

    protected SubversionUrl getReleaseBaseUrl() {
        return new SubversionUrl(this.config.get(CONFIG_RELEASE_BASE));
    }

    protected String getReleaseMessage() {
        return this.config.get(CONFIG_RELEASE_MESSAGE);
    }

    protected SubversionUrl getMainBaseUrl() {
        return new SubversionUrl(this.config.get(CONFIG_MAIN_BASE));
    }

    protected String getMergeMessage() {
        return this.config.get(CONFIG_MERGE_MESSAGE);
    }

    protected VersionFormatter getVersionFormatter() {
        return new VersionFormatter(this.config.get(CONFIG_VERSION_FORMAT));
    }

    public String getMergeMode() {
        return this.config.get(CONFIG_MERGE_MODE);
    }

    private static class ReleaseFilter
    implements Filter<SubversionUrl> {
        private static final Pattern PATTERN = Pattern.compile(Config.getInstance().get("release.filter"));

        private ReleaseFilter() {
        }

        @Override
        public boolean accept(SubversionUrl value) {
            return PATTERN.matcher(value.getName()).matches();
        }
    }

    private static class BranchFilter
    implements Filter<SubversionUrl> {
        private static final Pattern PATTERN = Pattern.compile(Config.getInstance().get("branch.filter"));

        private BranchFilter() {
        }

        @Override
        public boolean accept(SubversionUrl value) {
            return PATTERN.matcher(value.getName()).matches();
        }
    }
}

