/*
 * Decompiled with CFR 0.152.
 */
package org.wooddog.mavenplugins.version.plugin;

import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.wooddog.mavenplugins.version.Pom;
import org.wooddog.mavenplugins.version.SubversionUrl;
import org.wooddog.mavenplugins.version.SvnUtil;
import org.wooddog.mavenplugins.version.Version;
import org.wooddog.mavenplugins.version.exception.BadBranchVersionException;
import org.wooddog.mavenplugins.version.exception.DirtyRepositoryException;
import org.wooddog.mavenplugins.version.exception.UnMergedBranchException;
import org.wooddog.mavenplugins.version.exception.VersionLoadException;
import org.wooddog.mavenplugins.version.exception.VersionSaveException;
import org.wooddog.mavenplugins.version.plugin.AbstractVersionMojo;

public class PromoteMojo
extends AbstractVersionMojo {
    private static final String ILLEGAL_STATES = "ACDMR!~";

    private void doBranch() throws MojoFailureException {
        SubversionUrl url;
        SvnUtil svn = new SvnUtil();
        String log = svn.update("-N", ".");
        String revision = svn.getValue(log, "^At revision (\\d+)\\.$");
        if (revision == null) {
            throw new MojoFailureException("no revision found of repo, " + log);
        }
        List<Version> versionList = svn.listVersions(this.getBranchBaseUrl(), this.getBranchFormatter(), this.getBranchFilter());
        Version latestVersion = versionList.isEmpty() ? null : versionList.get(0);
        String mergePoint = svn.propget("org.wooddog:merged", ".");
        log = svn.status(".");
        if (!(log = svn.filterLog(log, ILLEGAL_STATES)).isEmpty()) {
            this.getLog().error((CharSequence)("dirty files found in local repo:\n" + log));
            throw new DirtyRepositoryException("unable to branch when local repo is dirty please fix following files\n" + log);
        }
        if (latestVersion != null) {
            if (this.getProjectVersion().compareTo(latestVersion) <= 0) {
                throw new BadBranchVersionException("branch to promote is older than latest version in " + this.getBranchBaseUrl());
            }
            url = new SubversionUrl(this.getBranchBaseUrl(), this.getBranchFormatter().format(latestVersion));
            log = svn.diff(url.getUrl() + "@" + mergePoint, url.getUrl() + "@" + revision);
            if (!log.isEmpty()) {
                throw new UnMergedBranchException("unmerge changes found on " + this.getBranchBaseUrl());
            }
        }
        int[] versionTokens = this.getProjectVersion().getVersion();
        try {
            Version tmpVersion = new Version(versionTokens[0], versionTokens[1], 0, 1);
            Pom.getInstance().writeVersion(tmpVersion);
            url = new SubversionUrl(this.getReleaseBaseUrl(), this.getReleaseFormatter().format(tmpVersion));
            svn.copy("-m", this.getReleaseMessage(), ".", url.getUrl());
            this.getLog().info((CharSequence)("created release tag " + this.getReleaseFormatter().format(tmpVersion)));
            tmpVersion.promote();
            tmpVersion.setSnapShot(true);
            Pom.getInstance().writeVersion(tmpVersion);
            url = new SubversionUrl(this.getBranchBaseUrl(), this.getBranchFormatter().format(tmpVersion));
            mergePoint = svn.copy("-m", this.getBranchMessage(), ".", url.getUrl());
            this.getLog().info((CharSequence)("created release branch " + this.getBranchFormatter().format(tmpVersion)));
            tmpVersion = this.getProjectVersion();
            tmpVersion.promote();
            Pom.getInstance().writeVersion(tmpVersion);
        }
        catch (VersionLoadException x) {
            throw new MojoFailureException("unable to load version from pom, " + x.getMessage());
        }
        catch (VersionSaveException x) {
            throw new MojoFailureException("unable to write version to pom, " + x.getMessage());
        }
        svn.propset("org.wooddog:merged", mergePoint, ".");
        svn.commit("-N", "-m", this.getBranchMessage(), ".", "pom.xml");
    }

    private void doTag() throws MojoFailureException {
        SvnUtil svn = new SvnUtil();
        List<Version> versionList = svn.listVersions(this.getReleaseBaseUrl(), this.getReleaseFormatter(), this.getReleaseFilter());
        Version latestVersion = versionList.isEmpty() ? null : versionList.get(0);
        String log = svn.status(".");
        if (!(log = svn.filterLog(log, ILLEGAL_STATES)).isEmpty()) {
            this.getLog().error((CharSequence)("dirty files found in local repo:\n" + log));
            throw new DirtyRepositoryException("unable to branch when local repo is dirty please fix following files\n" + log);
        }
        if (latestVersion != null && this.getProjectVersion().compareTo(latestVersion) <= 0) {
            throw new BadBranchVersionException("branch to promote is older than latest version in " + this.getBranchBaseUrl());
        }
        Version version = this.getProjectVersion();
        try {
            version.setSnapShot(false);
            Pom.getInstance().writeVersion(version);
            SubversionUrl url = new SubversionUrl(this.getReleaseBaseUrl(), this.getReleaseFormatter().format(version));
            svn.copy("-m", this.getReleaseMessage(), ".", url.getUrl());
            this.getLog().info((CharSequence)("created release " + this.getReleaseFormatter().format(version)));
            version.promote();
            version.setSnapShot(true);
            Pom.getInstance().writeVersion(version);
            svn.commit("-N", "-m", this.getBranchMessage(), "pom.xml");
        }
        catch (VersionLoadException x) {
            throw new MojoFailureException("unable to load version from pom, " + x.getMessage());
        }
        catch (VersionSaveException x) {
            throw new MojoFailureException("unable to write version to pom, " + x.getMessage());
        }
    }

    @Override
    public void run() throws MojoFailureException, MojoExecutionException {
        if (this.getProjectVersion().isMainBranch()) {
            this.doBranch();
            return;
        }
        if (this.getProjectVersion().isReleaseBranch()) {
            this.doTag();
            return;
        }
        throw new BadBranchVersionException("local mirror cant be promoted please switch to the main or release branch");
    }
}

