/*
 * Decompiled with CFR 0.152.
 */
package org.wooddog.mavenplugins.version.report.merge;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoFailureException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.wooddog.mavenplugins.version.SubversionUrl;
import org.wooddog.mavenplugins.version.SvnUtil;

public class MergeLog {
    SvnUtil svn;
    List<String> conflictList;

    public void setMergeLog(String log) {
        this.conflictList = new ArrayList<String>();
        Pattern pattern = Pattern.compile("^C\\W+(\\w[\\W\\w]+)$", 8);
        Matcher matcher = pattern.matcher(log);
        while (matcher.find()) {
            this.conflictList.add(matcher.group(1));
        }
    }

    public void write(File file) {
    }

    private void build() throws MojoFailureException {
        Element element = DocumentFactory.getInstance().createElement("MergeLog");
        Document doc = DocumentFactory.getInstance().createDocument(element);
        for (String conflict : this.conflictList) {
            File file = new File(conflict);
            RevisionRevealer revealer = new RevisionRevealer(file);
            element = element.addElement("conflict");
            element.addElement("file").setText(file.getAbsolutePath());
            element.add(this.getLog("log-left", revealer.getLeft()));
            element.add(this.getLog("log-right", revealer.getRight()));
        }
    }

    private Element getDiff(SubversionUrl url, String revisionLeft, String revisionRight) throws MojoFailureException {
        String log = this.svn.diff("-r", revisionLeft + ":" + revisionRight, url.getUrl());
        return null;
    }

    private Element getLog(String elementName, String revision) throws MojoFailureException {
        Element element;
        String log = this.svn.log("--xml", "-r", revision);
        try {
            element = (Element)DocumentHelper.parseText((String)log).getRootElement().detach();
        }
        catch (DocumentException x) {
            throw new MojoFailureException("systax error in log for revision " + revision);
        }
        element.setName(elementName);
        return element;
    }

    private class RevisionRevealer {
        Pattern leftPattern;
        Pattern rightPattern;
        String left;
        String right;

        public RevisionRevealer(File file) throws MojoFailureException {
            this.leftPattern = Pattern.compile("^" + file.getName() + ".merge-left.r(\\d+)$");
            this.rightPattern = Pattern.compile("^" + file.getName() + ".merge-right.r(\\d+)$");
            this.revealRevision(file);
        }

        public String getLeft() {
            return this.left;
        }

        public String getRight() {
            return this.right;
        }

        private void revealRevision(File file) throws MojoFailureException {
            File[] files;
            for (File f : files = file.getParentFile().listFiles()) {
                this.exam(f);
            }
            if (this.left == null || this.right == null) {
                throw new MojoFailureException("unable to find conflict files for file " + file.getAbsolutePath());
            }
        }

        private void exam(File file) {
            Matcher matcher = this.leftPattern.matcher(file.getName());
            if (matcher.find()) {
                this.left = matcher.group(1);
            }
            if ((matcher = this.rightPattern.matcher(file.getName())).find()) {
                this.right = matcher.group(1);
            }
        }
    }
}

