/*
 * Decompiled with CFR 0.152.
 */
package org.wowtools.rmi;

import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.wowtools.rmi.ZookeeperUtil;

public class RmiClient {
    public static <T> T getService(String serviceUrl, String name) {
        String url = "rmi://" + serviceUrl + "/" + name;
        try {
            return (T)Naming.lookup(url);
        }
        catch (MalformedURLException | NotBoundException | RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> ZkServiceGetter<T> getServiceGetter(String zkUrl, String name) {
        ZkServiceGetter getter = new ZkServiceGetter(zkUrl, name);
        return getter;
    }

    public static class ZkServiceGetter<T> {
        private static final HashMap<String, ZookeeperUtil> zkuMap = new HashMap();
        private static final Random r = new Random();
        private final String zkPath;
        private final String name;
        private String[] serviceUrls;
        private T[] services;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ZkServiceGetter(String zkUrl, String name) {
            ZookeeperUtil zku;
            this.name = name;
            HashMap<String, ZookeeperUtil> hashMap = zkuMap;
            synchronized (hashMap) {
                zku = zkuMap.get(zkUrl);
                if (null == zku) {
                    zku = new ZookeeperUtil(zkUrl, null);
                    zkuMap.put(zkUrl, zku);
                }
            }
            final ZookeeperUtil zku1 = zku;
            Watcher watcher = new Watcher(){

                public void process(WatchedEvent event) {
                    if (event.getType() == Watcher.Event.EventType.NodeChildrenChanged) {
                        List<String> nodeList = zku1.watchChildren(zkPath, this);
                        ZkServiceGetter.access$102(this, this.toServiceUrls(zku1.getZk(), nodeList));
                        ZkServiceGetter.access$302(this, new Object[serviceUrls.length]);
                    }
                }
            };
            this.zkPath = "/catRmiService/" + name;
            List<String> nodeList = zku.watchChildren(this.zkPath, watcher);
            this.serviceUrls = this.toServiceUrls(zku.getZk(), nodeList);
            this.services = new Object[this.serviceUrls.length];
        }

        private String[] toServiceUrls(ZooKeeper zk, List<String> nodeList) {
            try {
                String[] urls = new String[nodeList.size()];
                int i = 0;
                for (String node : nodeList) {
                    byte[] data = zk.getData(this.zkPath + "/" + node, false, null);
                    urls[i] = new String(data);
                    ++i;
                }
                return urls;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public T getService() {
            int i;
            T res;
            if (this.services != null && this.services.length > 0 && (res = this.services[i = r.nextInt(this.serviceUrls.length)]) != null) {
                return res;
            }
            if (this.serviceUrls == null || this.serviceUrls.length == 0) {
                throw new RuntimeException("\u6682\u65e0\u53ef\u7528\u670d\u52a1:" + this.zkPath);
            }
            i = r.nextInt(this.serviceUrls.length);
            String url = this.serviceUrls[i];
            Object res2 = RmiClient.getService(url, this.name);
            this.services[i] = res2;
            return res2;
        }

        static /* synthetic */ String[] access$102(ZkServiceGetter x0, String[] x1) {
            x0.serviceUrls = x1;
            return x1;
        }

        static /* synthetic */ Object[] access$302(ZkServiceGetter x0, Object[] x1) {
            x0.services = x1;
            return x1;
        }
    }
}

