/*
 * Decompiled with CFR 0.152.
 */
package org.wowtools.rmi;

import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;

public class ZookeeperUtil {
    private final ZooKeeper zk;

    public ZookeeperUtil(String zkUrl, Integer zkSessionTimeOut) {
        if (null == zkSessionTimeOut) {
            zkSessionTimeOut = 5000;
        }
        this.zk = this.connectServer(zkUrl, zkSessionTimeOut);
    }

    private ZooKeeper connectServer(String zkUrl, int zkSessionTimeOut) {
        try {
            Watcher watcher = new Watcher(){

                public void process(WatchedEvent arg0) {
                }
            };
            return new ZooKeeper(zkUrl, zkSessionTimeOut, watcher);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void createNode(String path, byte[] data, CreateMode createMode) {
        try {
            this.zk.create(path, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, createMode);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> watchChildren(String path, Watcher watcher) {
        try {
            return this.zk.getChildren(path, watcher);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ZooKeeper getZk() {
        return this.zk;
    }
}

