/*
 * Decompiled with CFR 0.152.
 */
package org.wowtools.georewrite;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import org.khelekore.prtree.MBRConverter;
import org.khelekore.prtree.PRTree;

public class PrtreeIndex<T> {
    private final PRTree<PrtreeLeafNode> tree;

    public PrtreeIndex(Collection<T> features, GeometryBuilder<T> geometryBuilder) {
        ArrayList<PrtreeLeafNode> leafNodes = new ArrayList<PrtreeLeafNode>(features.size());
        for (T feature : features) {
            PrtreeLeafNode leafNode;
            double h;
            double w;
            Geometry geo = geometryBuilder.feature2Geometry(feature);
            if (null == geo) continue;
            Coordinate[] extent = geo.getEnvelope().getCoordinates();
            double xmin = extent[0].x;
            double ymin = extent[0].y;
            if (extent.length == 1) {
                w = 0.0;
                h = 0.0;
            } else if (extent.length == 5) {
                w = extent[2].x - xmin;
                h = extent[2].y - ymin;
            } else if (extent.length == 2) {
                w = extent[1].x - xmin;
                h = extent[1].y - ymin;
            } else {
                if (extent.length == 0) continue;
                throw new RuntimeException("\u672a\u5904\u7406\u7684extent:" + extent.length);
            }
            if (null == (leafNode = new PrtreeLeafNode(feature, xmin, ymin, w, h))) continue;
            leafNodes.add(leafNode);
        }
        int branchFactor = (int)Math.cbrt(Math.sqrt(leafNodes.size()));
        if (branchFactor < 4) {
            branchFactor = 4;
        }
        this.tree = new PRTree<PrtreeLeafNode>(new NodeConverter(), branchFactor);
        this.tree.load(leafNodes);
    }

    public void queryEnvIntersect(double xmin, double ymin, double xmax, double ymax, ResultVister<T> vister) {
        Iterable<PrtreeLeafNode> iterable = this.tree.find(xmin, ymin, xmax, ymax);
        iterable.forEach(treeNode -> vister.vist(((PrtreeLeafNode)treeNode).node));
    }

    protected class NodeConverter
    implements MBRConverter<PrtreeLeafNode> {
        protected NodeConverter() {
        }

        @Override
        public int getDimensions() {
            return 2;
        }

        @Override
        public double getMin(int axis, PrtreeLeafNode t) {
            return axis == 0 ? t.getMinX() : t.getMinY();
        }

        @Override
        public double getMax(int axis, PrtreeLeafNode t) {
            return axis == 0 ? t.getMaxX() : t.getMaxY();
        }
    }

    protected class PrtreeLeafNode
    extends Rectangle2D.Double {
        private static final long serialVersionUID = 1L;
        private T node;

        public PrtreeLeafNode(T node, double x, double y, double w, double h) {
            this.node = node;
            this.setRect(x, y, w, h);
        }

        @Override
        public boolean equals(Object obj) {
            PrtreeLeafNode other = (PrtreeLeafNode)obj;
            return this.node.equals(other.node);
        }

        @Override
        public int hashCode() {
            return this.node.hashCode();
        }
    }

    @FunctionalInterface
    public static interface GeometryBuilder<T> {
        public Geometry feature2Geometry(T var1);
    }

    @FunctionalInterface
    public static interface ResultVister<T> {
        public void vist(T var1);
    }
}

