/*
 * Decompiled with CFR 0.152.
 */
package org.wowtools.georewrite;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.h2.tools.SimpleResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GeoSqlQueryer {
    private static final Logger logger = LoggerFactory.getLogger(GeoSqlQueryer.class);
    private final HashMap<String, ColumnDefinition> columnInfo;
    private final String tableName;

    public GeoSqlQueryer(String tableName, HashMap<String, ColumnDefinition> columnInfo) {
        this.columnInfo = columnInfo;
        this.tableName = tableName;
    }

    public GeoSqlQueryer(String tableName) {
        this.columnInfo = null;
        this.tableName = tableName;
    }

    public abstract ResultSet query(Connection var1, String var2, String var3, String var4) throws SQLException;

    protected String[] columnPart2columnArr(String columnPart) {
        String[] columns = columnPart.split(",");
        for (int i = 0; i < columns.length; ++i) {
            String c = columns[i];
            int bAs = (c = c.replace("\"", "")).indexOf(" as ");
            if (bAs > 0) {
                c = c.substring(bAs + 4);
            }
            columns[i] = c;
        }
        return columns;
    }

    protected SimpleResultSet buildSimpleResultSetByColumns(String[] columns) throws SQLException {
        if (null == this.columnInfo) {
            throw new RuntimeException("\u672a\u901a\u8fc7 GeoSqlQueryer(HashMap<String, Integer> columnInfo)\u6307\u5b9a\u5217\u7c7b\u578b");
        }
        SimpleResultSet rs = new SimpleResultSet();
        try {
            for (String c : columns) {
                ColumnDefinition cd = this.columnInfo.get(c);
                if (null == cd) {
                    if ("fid".equals(c)) {
                        rs.addColumn("fid", 4, 10, 0);
                        continue;
                    }
                    if ("TCODE".equals(c)) {
                        rs.addColumn("TCODE", 12, 10, 0);
                        continue;
                    }
                    throw new RuntimeException("\u672a\u6307\u5b9a\u7684\u5217:" + this.tableName + "." + c);
                }
                int type = cd.type;
                if (type == 10000) {
                    type = -3;
                }
                rs.addColumn(c, type, cd.length, cd.precision);
            }
        }
        catch (Exception e) {
            logger.error("buildSimpleResultSetByColumns \u51fa\u9519", (Throwable)e);
            throw new RuntimeException("buildSimpleResultSetByColumns \u51fa\u9519", e);
        }
        return rs;
    }

    protected Geometry pg2Extent(String pg) {
        try {
            WKTReader r = new WKTReader();
            return r.read(pg);
        }
        catch (ParseException e) {
            throw new RuntimeException("\u89e3\u6790\u8f93\u5165\u8303\u56f4\u9519\u8bef:" + pg, e);
        }
    }

    protected double[] pg2ExtentCoord(Geometry geo) {
        Coordinate[] extent = geo.getEnvelope().getCoordinates();
        double xmin = extent[0].x;
        double ymin = extent[0].y;
        double xmax = extent[2].x;
        double ymax = extent[2].y;
        return new double[]{xmin, ymin, xmax, ymax};
    }

    protected double[] pg2ExtentCoord(String pg) {
        try {
            WKTReader r = new WKTReader();
            Geometry geo = r.read(pg);
            return this.pg2ExtentCoord(geo);
        }
        catch (ParseException e) {
            throw new RuntimeException("\u89e3\u6790\u8f93\u5165\u8303\u56f4\u9519\u8bef:" + pg, e);
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public HashMap<String, ColumnDefinition> getColumnInfo() {
        return this.columnInfo;
    }

    public static class ColumnDefinition {
        public static final int Type_Geometry = 10000;
        public final String name;
        public final int type;
        public final int length;
        public final int precision;

        public ColumnDefinition(String name, int type, int length, int precision) {
            this.name = name;
            this.type = type;
            this.length = length;
            this.precision = precision;
        }
    }

    @FunctionalInterface
    protected static interface ObjGetter<T> {
        public Object get(T var1, int var2, String var3);
    }
}

