/*
 * Decompiled with CFR 0.152.
 */
package org.wowtools.georewrite;

import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.h2.jdbcx.JdbcConnectionPool;
import org.h2.tools.Server;
import org.json.JSONArray;
import org.json.JSONObject;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wowtools.common.utils.PropertiesReader;
import org.wowtools.common.utils.ResourcesReader;
import org.wowtools.georewrite.GeoSqlQueryer;
import org.wowtools.georewrite.GeoSqlRewriter;
import org.wowtools.georewrite.GeoSqlRewriterFunction;
import org.wowtools.h2.sqlrewriter.SqlRewriter;
import org.wowtools.h2.sqlrewriter.SqlRewriterManager;
import org.wowtools.h2.usrfun.UserFunctionManager;

public class GwH2Manager {
    private static final Logger logger = LoggerFactory.getLogger(GwH2Manager.class);
    private final Class<?> startClass;
    private final PropertiesReader pr;
    private JdbcConnectionPool connPool;

    public GwH2Manager(Class<?> startClass) {
        this.startClass = startClass;
        this.pr = new PropertiesReader(startClass, "conf/gwConfig.properties");
    }

    public void start() {
        String dbName = this.pr.getString("dbName");
        String superDbUserName = this.pr.getString("superDbUserName");
        String superDbUserPwd = this.pr.getString("superDbUserPwd");
        JdbcConnectionPool connectionPool = JdbcConnectionPool.create((String)("jdbc:h2:mem:" + dbName + ";MVCC=TRUE"), (String)superDbUserName, (String)superDbUserPwd);
        connectionPool.setMaxConnections(this.pr.getInteger("maxConnections").intValue());
        try {
            Server tcpServer = Server.createTcpServer((String[])new String[]{"-tcpPort", this.pr.getString("tcpPort"), "-tcpAllowOthers"});
            tcpServer.start();
        }
        catch (SQLException e) {
            throw new RuntimeException("\u542f\u52a8tcp\u670d\u52a1\u5f02\u5e38", e);
        }
        this.connPool = connectionPool;
        try {
            UserFunctionManager.register((Connection)this.connPool.getConnection(), GeoSqlRewriterFunction.class);
        }
        catch (SQLException e) {
            throw new RuntimeException("\u6ce8\u518c\u81ea\u5b9a\u4e49\u51fd\u6570\u5f02\u5e38", e);
        }
        SqlRewriterManager.add((SqlRewriter)new GeoSqlRewriter());
        logger.info("\u6570\u636e\u5e93\u542f\u52a8\u5b8c\u6bd5");
    }

    public Connection getConnection() {
        try {
            return this.connPool.getConnection();
        }
        catch (SQLException e) {
            throw new RuntimeException("\u83b7\u53d6\u5185\u5b58\u5e93\u8fde\u63a5\u5f02\u5e38", e);
        }
    }

    public PropertiesReader getGwConfig() {
        return this.pr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadTables() {
        System.out.println(logger.getName());
        String rootPath = ResourcesReader.getRootPath(this.startClass);
        String strPath = rootPath + "/conf/tables";
        File tablesPath = new File(strPath);
        if (!tablesPath.exists()) {
            logger.warn("\u8868\u8def\u5f84{}\u4e0d\u5b58\u5728,\u8df3\u8fc7\u52a0\u8f7d", (Object)strPath);
            return 0;
        }
        File[] files = tablesPath.listFiles((dir, name) -> name.indexOf(".json") > 0);
        logger.info("\u53d1\u73b0\u8868\u914d\u7f6ejson\u6587\u4ef6\u6570:{}", (Object)files.length);
        int n = 0;
        DataStore datastore = this.getDataStore();
        for (File f : files) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(f);
                byte[] b = new byte[is.available()];
                is.read(b);
                String str = new String(b);
                JSONObject jo = new JSONObject(str);
                this.loadTable(jo, datastore);
                ++n;
            }
            catch (Exception e) {
                logger.warn("\u52a0\u8f7d\u8868\u914d\u7f6e\u51fa\u9519:" + f.getName(), (Throwable)e);
            }
            finally {
                if (null != is) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        logger.info("\u52a0\u8f7d\u6570\u636e\u8868\u5b8c\u6210,\u6210\u529f\u52a0\u8f7d\u6570{}", (Object)n);
        return n;
    }

    public void loadTable(JSONObject jo, DataStore datastore) {
        GeoSqlQueryer query;
        String tableName = jo.getString("tableName");
        JSONArray ja = jo.getJSONArray("columns");
        HashMap<String, GeoSqlQueryer.ColumnDefinition> columnInfo = new HashMap<String, GeoSqlQueryer.ColumnDefinition>(ja.length());
        int n = ja.length();
        for (int i = 0; i < n; ++i) {
            JSONObject jc = ja.getJSONObject(i);
            String name = jc.getString("name");
            GeoSqlQueryer.ColumnDefinition cd = new GeoSqlQueryer.ColumnDefinition(name, jc.getInt("type"), jc.getInt("length"), jc.getInt("precision"));
            columnInfo.put(name, cd);
        }
        try {
            String impl = jo.getString("impl");
            Class<?> clazz = Class.forName(impl);
            Constructor<?> cons = clazz.getConstructor(String.class, HashMap.class, JSONObject.class);
            JSONObject initParam = jo.has("initParam") ? jo.getJSONObject("initParam") : null;
            query = (GeoSqlQueryer)cons.newInstance(tableName, columnInfo, initParam);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6784\u9020queryer\u5b9e\u4f8b\u51fa\u9519", e);
        }
        this.loadTable(query, datastore);
    }

    public void loadTable(GeoSqlQueryer queryer, DataStore datastore) {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setNamespaceURI("http://acme.com");
        tb.setName(queryer.getTableName());
        queryer.getColumnInfo().forEach((name, cd) -> {
            Class clazz = cd.type == 10000 ? Geometry.class : (cd.type == 4 ? Integer.class : (cd.type == 2 ? Double.class : String.class));
            tb.add(name, clazz);
        });
        tb.add("TCODE", String.class);
        SimpleFeatureType type = tb.buildFeatureType();
        try {
            datastore.createSchema((FeatureType)type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        GeoSqlRewriterFunction.registerGeoSqlQueryer(queryer.getTableName(), queryer);
    }

    public DataStore getDataStore() {
        DataStore datastore;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dbtype", "h2");
        params.put("host", this.pr.getString("ip"));
        params.put("port", this.pr.getInteger("tcpPort"));
        params.put("database", "mem:" + this.pr.getString("dbName"));
        params.put("user", this.pr.getString("superDbUserName"));
        params.put("passwd", this.pr.getString("superDbUserPwd"));
        params.put("create spatial index", Boolean.TRUE);
        try {
            datastore = DataStoreFinder.getDataStore(params);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return datastore;
    }
}

