/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.Table;
import org.h2.table.TableType;
import org.h2.table.TableView;

public class DropView
extends SchemaCommand {
    private String viewName;
    private boolean ifExists;
    private int dropAction;

    public DropView(Session session, Schema schema) {
        super(session, schema);
        this.dropAction = session.getDatabase().getSettings().dropRestrict ? 0 : 1;
    }

    public void setIfExists(boolean b) {
        this.ifExists = b;
    }

    public void setDropAction(int dropAction) {
        this.dropAction = dropAction;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    @Override
    public int update() {
        this.session.commit(true);
        Table view = this.getSchema().findTableOrView(this.session, this.viewName);
        if (view == null) {
            if (!this.ifExists) {
                throw DbException.get(90037, this.viewName);
            }
        } else {
            if (TableType.VIEW != view.getTableType()) {
                throw DbException.get(90037, this.viewName);
            }
            this.session.getUser().checkRight(view, 15);
            if (this.dropAction == 0) {
                for (DbObject child : view.getChildren()) {
                    if (!(child instanceof TableView)) continue;
                    throw DbException.get(90107, this.viewName, child.getName());
                }
            }
            view.lock(this.session, true, true);
            this.session.getDatabase().removeSchemaObject(this.session, view);
        }
        return 0;
    }

    @Override
    public int getType() {
        return 48;
    }
}

