/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.Map;
import java.util.TreeMap;
import org.h2.command.Prepared;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.mvstore.db.MVTableEngine;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.store.PageStore;
import org.h2.table.Column;
import org.h2.value.Value;
import org.h2.value.ValueString;

public class Explain
extends Prepared {
    private Prepared command;
    private LocalResult result;
    private boolean executeCommand;

    public Explain(Session session) {
        super(session);
    }

    public void setCommand(Prepared command) {
        this.command = command;
    }

    public Prepared getCommand() {
        return this.command;
    }

    @Override
    public void prepare() {
        this.command.prepare();
    }

    public void setExecuteCommand(boolean executeCommand) {
        this.executeCommand = executeCommand;
    }

    @Override
    public ResultInterface queryMeta() {
        return this.query(-1);
    }

    @Override
    public ResultInterface query(int maxrows) {
        Column column = new Column("PLAN", 13);
        Database db = this.session.getDatabase();
        ExpressionColumn expr = new ExpressionColumn(db, column);
        Expression[] expressions = new Expression[]{expr};
        this.result = new LocalResult(this.session, expressions, 1);
        if (maxrows >= 0) {
            String plan;
            if (this.executeCommand) {
                PageStore store = null;
                MVTableEngine.Store mvStore = null;
                if (db.isPersistent()) {
                    store = db.getPageStore();
                    if (store != null) {
                        store.statisticsStart();
                    }
                    if ((mvStore = db.getMvStore()) != null) {
                        mvStore.statisticsStart();
                    }
                }
                if (this.command.isQuery()) {
                    this.command.query(maxrows);
                } else {
                    this.command.update();
                }
                plan = this.command.getPlanSQL();
                Map<String, Integer> statistics = null;
                if (store != null) {
                    statistics = store.statisticsEnd();
                } else if (mvStore != null) {
                    statistics = mvStore.statisticsEnd();
                }
                if (statistics != null) {
                    int total = 0;
                    for (Map.Entry<String, Integer> e : statistics.entrySet()) {
                        total += e.getValue().intValue();
                    }
                    if (total > 0) {
                        statistics = new TreeMap<String, Integer>(statistics);
                        StringBuilder buff = new StringBuilder();
                        if (statistics.size() > 1) {
                            buff.append("total: ").append(total).append('\n');
                        }
                        for (Map.Entry<String, Integer> e : statistics.entrySet()) {
                            int value = e.getValue();
                            int percent = (int)(100L * (long)value / (long)total);
                            buff.append(e.getKey()).append(": ").append(value);
                            if (statistics.size() > 1) {
                                buff.append(" (").append(percent).append("%)");
                            }
                            buff.append('\n');
                        }
                        plan = plan + "\n/*\n" + buff.toString() + "*/";
                    }
                }
            } else {
                plan = this.command.getPlanSQL();
            }
            this.add(plan);
        }
        this.result.done();
        return this.result;
    }

    private void add(String text) {
        Value[] row = new Value[]{ValueString.get(text)};
        this.result.addRow(row);
    }

    @Override
    public boolean isQuery() {
        return true;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return this.command.isReadOnly();
    }

    @Override
    public int getType() {
        return 60;
    }
}

