/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import org.h2.index.PageBtreeCursor;
import org.h2.index.PageBtreeIndex;
import org.h2.index.PageBtreeLeaf;
import org.h2.result.SearchRow;
import org.h2.store.Data;
import org.h2.store.Page;

public abstract class PageBtree
extends Page {
    static final int ROOT = 0;
    static final int UNKNOWN_ROWCOUNT = -1;
    protected final PageBtreeIndex index;
    protected int parentPageId;
    protected final Data data;
    protected int[] offsets;
    protected int entryCount;
    protected SearchRow[] rows;
    protected int start;
    protected boolean onlyPosition;
    protected boolean written;
    private final int memoryEstimated;

    PageBtree(PageBtreeIndex index, int pageId, Data data) {
        this.index = index;
        this.data = data;
        this.setPos(pageId);
        this.memoryEstimated = index.getMemoryPerPage();
    }

    abstract int getRowCount();

    abstract void setRowCountStored(int var1);

    int find(SearchRow compare, boolean bigger, boolean add, boolean compareKeys) {
        if (compare == null) {
            return 0;
        }
        int l = 0;
        int r = this.entryCount;
        int comp = 1;
        while (l < r) {
            int i = l + r >>> 1;
            SearchRow row = this.getRow(i);
            comp = this.index.compareRows(row, compare);
            if (comp == 0) {
                if (add && this.index.indexType.isUnique() && !this.index.containsNullAndAllowMultipleNull(compare)) {
                    throw this.index.getDuplicateKeyException(compare.toString());
                }
                if (compareKeys && (comp = this.index.compareKeys(row, compare)) == 0) {
                    return i;
                }
            }
            if (comp > 0 || !bigger && comp == 0) {
                r = i;
                continue;
            }
            l = i + 1;
        }
        return l;
    }

    abstract int addRowTry(SearchRow var1);

    abstract void find(PageBtreeCursor var1, SearchRow var2, boolean var3);

    abstract void last(PageBtreeCursor var1);

    SearchRow getRow(int at) {
        SearchRow row = this.rows[at];
        if (row == null) {
            row = this.index.readRow(this.data, this.offsets[at], this.onlyPosition, true);
            this.memoryChange();
            this.rows[at] = row;
        } else if (!this.index.hasData(row)) {
            row = this.index.readRow(row.getKey());
            this.memoryChange();
            this.rows[at] = row;
        }
        return row;
    }

    protected void memoryChange() {
    }

    abstract PageBtree split(int var1);

    void setPageId(int id) {
        this.changeCount = this.index.getPageStore().getChangeCount();
        this.written = false;
        this.index.getPageStore().removeFromCache(this.getPos());
        this.setPos(id);
        this.index.getPageStore().logUndo(this, null);
        this.remapChildren();
    }

    abstract PageBtreeLeaf getFirstLeaf();

    abstract PageBtreeLeaf getLastLeaf();

    void setParentPageId(int id) {
        this.index.getPageStore().logUndo(this, this.data);
        this.changeCount = this.index.getPageStore().getChangeCount();
        this.written = false;
        this.parentPageId = id;
    }

    abstract void remapChildren();

    abstract SearchRow remove(SearchRow var1);

    abstract void freeRecursive();

    protected void readAllRows() {
        for (int i = 0; i < this.entryCount; ++i) {
            SearchRow row = this.rows[i];
            if (row != null) continue;
            this.rows[i] = row = this.index.readRow(this.data, this.offsets[i], this.onlyPosition, false);
        }
    }

    @Override
    public int getMemory() {
        return this.memoryEstimated;
    }

    @Override
    public boolean canRemove() {
        return this.changeCount < this.index.getPageStore().getChangeCount();
    }
}

