/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.h2.api.TableEngine;
import org.h2.command.ddl.CreateTableData;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.FileStore;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.MVStoreTool;
import org.h2.mvstore.db.MVTable;
import org.h2.mvstore.db.TransactionStore;
import org.h2.mvstore.db.ValueDataType;
import org.h2.store.InDoubtTransaction;
import org.h2.store.fs.FileChannelInputStream;
import org.h2.store.fs.FileUtils;
import org.h2.table.TableBase;
import org.h2.util.BitField;
import org.h2.util.New;

public class MVTableEngine
implements TableEngine {
    public static Store init(final Database db) {
        Store store = db.getMvStore();
        if (store != null) {
            return store;
        }
        byte[] key = db.getFileEncryptionKey();
        String dbPath = db.getDatabasePath();
        MVStore.Builder builder = new MVStore.Builder();
        store = new Store();
        boolean encrypted = false;
        if (dbPath != null) {
            String fileName = dbPath + ".mv.db";
            MVStoreTool.compactCleanUp(fileName);
            builder.fileName(fileName);
            builder.pageSplitSize(db.getPageSize());
            if (db.isReadOnly()) {
                builder.readOnly();
            } else {
                boolean exists = FileUtils.exists(fileName);
                if (!exists || FileUtils.canWrite(fileName)) {
                    String dir = FileUtils.getParent(fileName);
                    FileUtils.createDirectories(dir);
                }
            }
            if (key != null) {
                encrypted = true;
                char[] password = new char[key.length / 2];
                for (int i = 0; i < password.length; ++i) {
                    password[i] = (char)((key[i + i] & 0xFF) << 16 | key[i + i + 1] & 0xFF);
                }
                builder.encryptionKey(password);
            }
            if (db.getSettings().compressData) {
                builder.compress();
                builder.pageSplitSize(65536);
            }
            builder.backgroundExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    db.setBackgroundException(DbException.convert(e));
                }
            });
        }
        store.open(db, builder, encrypted);
        db.setMvStore(store);
        return store;
    }

    @Override
    public TableBase createTable(CreateTableData data) {
        Database db = data.session.getDatabase();
        Store store = MVTableEngine.init(db);
        MVTable table = new MVTable(data, store);
        table.init(data.session);
        store.tableMap.put(table.getMapName(), table);
        return table;
    }

    private static class MVInDoubtTransaction
    implements InDoubtTransaction {
        private final MVStore store;
        private final TransactionStore.Transaction transaction;
        private int state = 0;

        MVInDoubtTransaction(MVStore store, TransactionStore.Transaction transaction) {
            this.store = store;
            this.transaction = transaction;
        }

        @Override
        public void setState(int state) {
            if (state == 1) {
                this.transaction.commit();
            } else {
                this.transaction.rollback();
            }
            this.store.commit();
            this.state = state;
        }

        @Override
        public String getState() {
            switch (this.state) {
                case 0: {
                    return "IN_DOUBT";
                }
                case 1: {
                    return "COMMIT";
                }
                case 2: {
                    return "ROLLBACK";
                }
            }
            throw DbException.throwInternalError("state=" + this.state);
        }

        @Override
        public String getTransactionName() {
            return this.transaction.getName();
        }
    }

    public static class Store {
        final ConcurrentHashMap<String, MVTable> tableMap = new ConcurrentHashMap();
        private MVStore store;
        private TransactionStore transactionStore;
        private long statisticsStart;
        private int temporaryMapId;
        private boolean encrypted;
        private String fileName;

        void open(Database db, MVStore.Builder builder, boolean encrypted) {
            this.encrypted = encrypted;
            try {
                this.store = builder.open();
                FileStore fs = this.store.getFileStore();
                if (fs != null) {
                    this.fileName = fs.getFileName();
                }
                if (!db.getSettings().reuseSpace) {
                    this.store.setReuseSpace(false);
                }
                this.transactionStore = new TransactionStore(this.store, new ValueDataType(null, db, null));
                this.transactionStore.init();
            }
            catch (IllegalStateException e) {
                throw this.convertIllegalStateException(e);
            }
        }

        DbException convertIllegalStateException(IllegalStateException e) {
            int errorCode = DataUtils.getErrorCode(e.getMessage());
            if (errorCode == 6) {
                if (this.encrypted) {
                    throw DbException.get(90049, e, this.fileName);
                }
            } else {
                if (errorCode == 7) {
                    throw DbException.get(90020, e, this.fileName);
                }
                if (errorCode == 1) {
                    throw DbException.get(90028, e, this.fileName);
                }
            }
            throw DbException.get(90030, e, this.fileName);
        }

        public MVStore getStore() {
            return this.store;
        }

        public TransactionStore getTransactionStore() {
            return this.transactionStore;
        }

        public HashMap<String, MVTable> getTables() {
            return new HashMap<String, MVTable>(this.tableMap);
        }

        public void removeTable(MVTable table) {
            this.tableMap.remove(table.getMapName());
        }

        public void flush() {
            FileStore s = this.store.getFileStore();
            if (s == null || s.isReadOnly()) {
                return;
            }
            if (!this.store.compact(50, 0x400000)) {
                this.store.commit();
            }
        }

        public void closeImmediately() {
            if (this.store.isClosed()) {
                return;
            }
            this.store.closeImmediately();
        }

        public void initTransactions() {
            List<TransactionStore.Transaction> list = this.transactionStore.getOpenTransactions();
            for (TransactionStore.Transaction t : list) {
                if (t.getStatus() == 3) {
                    t.commit();
                    continue;
                }
                if (t.getStatus() == 2) continue;
                t.rollback();
            }
        }

        public void removeTemporaryMaps(BitField objectIds) {
            for (String mapName : this.store.getMapNames()) {
                int id;
                if (mapName.startsWith("temp.")) {
                    MVMap map = this.store.openMap(mapName);
                    this.store.removeMap(map);
                    continue;
                }
                if (!mapName.startsWith("table.") && !mapName.startsWith("index.") || objectIds.get(id = Integer.parseInt(mapName.substring(1 + mapName.indexOf("."))))) continue;
                ValueDataType keyType = new ValueDataType(null, null, null);
                ValueDataType valueType = new ValueDataType(null, null, null);
                TransactionStore.Transaction t = this.transactionStore.begin();
                TransactionStore.TransactionMap m = t.openMap(mapName, keyType, valueType);
                this.transactionStore.removeMap(m);
                t.commit();
            }
        }

        public synchronized String nextTemporaryMapName() {
            return "temp." + this.temporaryMapId++;
        }

        public void prepareCommit(Session session, String transactionName) {
            TransactionStore.Transaction t = session.getTransaction();
            t.setName(transactionName);
            t.prepare();
            this.store.commit();
        }

        public ArrayList<InDoubtTransaction> getInDoubtTransactions() {
            List<TransactionStore.Transaction> list = this.transactionStore.getOpenTransactions();
            ArrayList<InDoubtTransaction> result = New.arrayList();
            for (TransactionStore.Transaction t : list) {
                if (t.getStatus() != 2) continue;
                result.add(new MVInDoubtTransaction(this.store, t));
            }
            return result;
        }

        public void setCacheSize(int kb) {
            this.store.setCacheSize(Math.max(1, kb / 1024));
        }

        public InputStream getInputStream() {
            FileChannel fc = this.store.getFileStore().getEncryptedFile();
            if (fc == null) {
                fc = this.store.getFileStore().getFile();
            }
            return new FileChannelInputStream(fc, false);
        }

        public void sync() {
            this.flush();
            this.store.sync();
        }

        public void compactFile(long maxCompactTime) {
            this.store.setRetentionTime(0);
            long start = System.currentTimeMillis();
            while (this.store.compact(95, 0x1000000)) {
                this.store.sync();
                this.store.compactMoveChunks(95, 0x1000000L);
                long time = System.currentTimeMillis() - start;
                if (time <= maxCompactTime) continue;
                break;
            }
        }

        public void close(long maxCompactTime) {
            try {
                if (!this.store.isClosed() && this.store.getFileStore() != null) {
                    boolean compactFully = false;
                    if (!this.store.getFileStore().isReadOnly()) {
                        this.transactionStore.close();
                        if (maxCompactTime == Long.MAX_VALUE) {
                            compactFully = true;
                        }
                    }
                    String fileName = this.store.getFileStore().getFileName();
                    this.store.close();
                    if (compactFully && FileUtils.exists(fileName)) {
                        MVStoreTool.compact(fileName, true);
                    }
                }
            }
            catch (IllegalStateException e) {
                int errorCode = DataUtils.getErrorCode(e.getMessage());
                if (errorCode == 2 || errorCode == 6) {
                    // empty if block
                }
                this.store.closeImmediately();
                throw DbException.get(90028, e, "Closing");
            }
        }

        public void statisticsStart() {
            FileStore fs = this.store.getFileStore();
            this.statisticsStart = fs == null ? 0L : fs.getReadCount();
        }

        public Map<String, Integer> statisticsEnd() {
            HashMap<String, Integer> map = New.hashMap();
            FileStore fs = this.store.getFileStore();
            int reads = fs == null ? 0 : (int)(fs.getReadCount() - this.statisticsStart);
            map.put("reads", reads);
            return map;
        }
    }
}

