/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.h2.command.dml.Query;
import org.h2.command.dml.Select;
import org.h2.command.dml.SelectUnion;
import org.h2.index.Cursor;
import org.h2.index.IndexCursor;
import org.h2.index.IndexLookupBatch;
import org.h2.index.ViewCursor;
import org.h2.index.ViewIndex;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.table.TableFilter;
import org.h2.util.DoneFuture;
import org.h2.util.LazyFuture;
import org.h2.util.New;
import org.h2.value.Value;
import org.h2.value.ValueLong;

public final class JoinBatch {
    static final Cursor EMPTY_CURSOR = new Cursor(){

        @Override
        public boolean previous() {
            return false;
        }

        @Override
        public boolean next() {
            return false;
        }

        @Override
        public SearchRow getSearchRow() {
            return null;
        }

        @Override
        public Row get() {
            return null;
        }

        public String toString() {
            return "EMPTY_CURSOR";
        }
    };
    static final Future<Cursor> EMPTY_FUTURE_CURSOR = new DoneFuture<Cursor>(EMPTY_CURSOR);
    Future<Cursor> viewTopFutureCursor;
    JoinFilter top;
    JoinFilter[] filters;
    boolean batchedSubQuery;
    private boolean started;
    private JoinRow current;
    private boolean found;
    private final TableFilter additionalFilter;

    public JoinBatch(int filtersCount, TableFilter additionalFilter) {
        if (filtersCount > 32) {
            throw DbException.getUnsupportedException("Too many tables in join (at most 32 supported).");
        }
        this.filters = new JoinFilter[filtersCount];
        this.additionalFilter = additionalFilter;
    }

    public IndexLookupBatch getLookupBatch(int joinFilterId) {
        return this.filters[joinFilterId].lookupBatch;
    }

    public void reset(boolean beforeQuery) {
        this.current = null;
        this.started = false;
        this.found = false;
        for (JoinFilter jf : this.filters) {
            jf.reset(beforeQuery);
        }
        if (beforeQuery && this.additionalFilter != null) {
            this.additionalFilter.reset();
        }
    }

    public void register(TableFilter filter, IndexLookupBatch lookupBatch) {
        assert (filter != null);
        this.filters[this.top.id] = this.top = new JoinFilter(lookupBatch, filter, this.top);
    }

    public Value getValue(int filterId, Column column) {
        Object x = this.current.row(filterId);
        assert (x != null);
        Row row = this.current.isRow(filterId) ? (Row)x : ((Cursor)x).get();
        int columnId = column.getColumnId();
        if (columnId == -1) {
            return ValueLong.get(row.getKey());
        }
        Value value = row.getValue(column.getColumnId());
        if (value == null) {
            throw DbException.throwInternalError("value is null: " + column + " " + row);
        }
        return value;
    }

    private void start() {
        Cursor cursor;
        this.current = new JoinRow(new Object[this.filters.length]);
        if (this.batchedSubQuery) {
            assert (this.viewTopFutureCursor != null);
            cursor = JoinBatch.get(this.viewTopFutureCursor);
        } else {
            TableFilter f = this.top.filter;
            IndexCursor indexCursor = f.getIndexCursor();
            indexCursor.find(f.getSession(), f.getIndexConditions());
            cursor = indexCursor;
        }
        this.current.updateRow(this.top.id, cursor, 0L, 2L);
        JoinRow fake = new JoinRow(null);
        fake.next = this.current;
        this.current = fake;
    }

    public boolean next() {
        if (!this.started) {
            this.start();
            this.started = true;
        }
        if (this.additionalFilter == null) {
            if (this.batchedNext()) {
                assert (this.current.isComplete());
                return true;
            }
            return false;
        }
        while (true) {
            if (!this.found) {
                if (!this.batchedNext()) {
                    return false;
                }
                assert (this.current.isComplete());
                this.found = true;
                this.additionalFilter.reset();
            }
            if (this.additionalFilter.next()) {
                return true;
            }
            this.found = false;
        }
    }

    private static Cursor get(Future<Cursor> f) {
        Cursor c;
        try {
            c = f.get();
        }
        catch (Exception e) {
            throw DbException.convert(e);
        }
        return c == null ? EMPTY_CURSOR : c;
    }

    /*
     * Unable to fully structure code
     */
    private boolean batchedNext() {
        if (this.current == null) {
            return false;
        }
        this.current = this.current.next;
        if (this.current == null) {
            return false;
        }
        this.current.prev = null;
        jfId = lastJfId = this.filters.length - 1;
        while (this.current.row(jfId) == null) {
            --jfId;
        }
        block1: while (true) {
            this.fetchCurrent(jfId);
            if (!this.current.isDropped()) {
                if (jfId == lastJfId) {
                    return true;
                }
                join = this.filters[jfId + 1];
                if (join.isBatchFull()) {
                    this.current = join.find(this.current);
                }
                if (this.current.row(join.id) != null) {
                    jfId = join.id;
                    continue;
                }
            }
            if (this.current.next == null) {
                if (this.current.isDropped()) {
                    this.current = this.current.prev;
                    if (this.current == null) {
                        return false;
                    }
                }
                if (!JoinBatch.$assertionsDisabled && this.current.isDropped()) {
                    throw new AssertionError();
                }
                if (!JoinBatch.$assertionsDisabled && jfId == lastJfId) {
                    throw new AssertionError();
                }
                jfId = 0;
                while (this.current.row(jfId) != null) {
                    ++jfId;
                }
                this.current = this.filters[jfId].find(this.current);
                continue;
            }
            this.current = this.current.next;
            if (!JoinBatch.$assertionsDisabled && this.current.isRow(jfId)) {
                throw new AssertionError();
            }
            do {
                if (this.current.row(jfId) == null) ** break;
                continue block1;
                if (!JoinBatch.$assertionsDisabled && jfId == this.top.id) {
                    throw new AssertionError();
                }
            } while (JoinBatch.$assertionsDisabled || !this.current.isRow(--jfId));
            break;
        }
        throw new AssertionError();
    }

    private void fetchCurrent(int jfId) {
        boolean joinEmpty;
        JoinFilter join;
        Cursor c;
        block15: {
            boolean newCursor;
            assert (this.current.prev == null || this.current.prev.isRow(jfId)) : "prev must be already fetched";
            assert (jfId == 0 || this.current.isRow(jfId - 1)) : "left must be already fetched";
            assert (!this.current.isRow(jfId)) : "double fetching";
            Object x = this.current.row(jfId);
            assert (x != null) : "x null";
            boolean bl = newCursor = x == EMPTY_CURSOR;
            if (newCursor) {
                if (jfId == 0) {
                    this.current.drop();
                    return;
                }
            } else if (this.current.isFuture(jfId)) {
                x = JoinBatch.get((Future)x);
                this.current.updateRow(jfId, x, 1L, 2L);
                newCursor = true;
            }
            JoinFilter jf = this.filters[jfId];
            c = (Cursor)x;
            assert (c != null);
            join = jf.join;
            while (true) {
                if (c == null || !c.next()) {
                    if (newCursor && jf.isOuterJoin()) {
                        this.current.updateRow(jfId, jf.getNullRow(), 2L, 3L);
                        c = null;
                        newCursor = false;
                    } else {
                        this.current.drop();
                        return;
                    }
                }
                if (!jf.isOk(c == null)) continue;
                joinEmpty = false;
                if (join == null || join.collectSearchRows()) break block15;
                if (join.isOuterJoin()) break;
            }
            joinEmpty = true;
        }
        if (c != null) {
            this.current = this.current.copyBehind(jfId);
            this.current.updateRow(jfId, c.get(), 2L, 3L);
        }
        if (joinEmpty) {
            this.current.updateRow(join.id, EMPTY_CURSOR, 0L, 2L);
        }
    }

    private IndexLookupBatch viewIndexLookupBatch(ViewIndex viewIndex) {
        return new ViewIndexLookupBatch(viewIndex);
    }

    public static IndexLookupBatch createViewIndexLookupBatch(ViewIndex viewIndex) {
        Query query = viewIndex.getQuery();
        if (query.isUnion()) {
            ViewIndexLookupBatchUnion unionBatch = new ViewIndexLookupBatchUnion(viewIndex);
            return unionBatch.initialize() ? unionBatch : null;
        }
        JoinBatch jb = ((Select)query).getJoinBatch();
        if (jb == null || jb.getLookupBatch(0) == null) {
            return null;
        }
        assert (!jb.batchedSubQuery);
        jb.batchedSubQuery = true;
        return jb.viewIndexLookupBatch(viewIndex);
    }

    public static IndexLookupBatch createFakeIndexLookupBatch(TableFilter filter) {
        return new FakeLookupBatch(filter);
    }

    public String toString() {
        return "JoinBatch->\nprev->" + (this.current == null ? null : this.current.prev) + "\n" + "curr->" + this.current + "\n" + "next->" + (this.current == null ? null : this.current.next);
    }

    private static class QueryRunnerUnion
    extends QueryRunnerBase {
        Future<Cursor>[] topFutureCursors;
        private ViewIndexLookupBatchUnion batchUnion;

        public QueryRunnerUnion(ViewIndexLookupBatchUnion batchUnion) {
            super(batchUnion.viewIndex);
            this.batchUnion = batchUnion;
            this.topFutureCursors = new Future[batchUnion.filters.size()];
        }

        @Override
        protected void clear() {
            super.clear();
            for (int i = 0; i < this.topFutureCursors.length; ++i) {
                this.topFutureCursors[i] = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Cursor run() throws Exception {
            int size;
            LocalResult localResult;
            this.viewIndex.setupQueryParameters(this.viewIndex.getSession(), this.first, this.last, null);
            ArrayList<JoinBatch> joinBatches = this.batchUnion.joinBatches;
            int size2 = joinBatches.size();
            for (int i = 0; i < size2; ++i) {
                assert (this.topFutureCursors[i] != null);
                joinBatches.get((int)i).viewTopFutureCursor = this.topFutureCursors[i];
            }
            try {
                localResult = this.viewIndex.getQuery().query(0);
                size = joinBatches.size();
            }
            catch (Throwable throwable) {
                int size3 = joinBatches.size();
                for (int i = 0; i < size3; ++i) {
                    joinBatches.get((int)i).viewTopFutureCursor = null;
                }
                throw throwable;
            }
            for (int i = 0; i < size; ++i) {
                joinBatches.get((int)i).viewTopFutureCursor = null;
            }
            return this.newCursor(localResult);
        }
    }

    private static final class ViewIndexLookupBatchUnion
    extends ViewIndexLookupBatchBase<QueryRunnerUnion> {
        ArrayList<JoinFilter> filters;
        ArrayList<JoinBatch> joinBatches;
        private boolean onlyBatchedQueries = true;

        protected ViewIndexLookupBatchUnion(ViewIndex viewIndex) {
            super(viewIndex);
        }

        boolean initialize() {
            return this.collectJoinBatches(this.viewIndex.getQuery()) && this.joinBatches != null;
        }

        private boolean collectJoinBatches(Query query) {
            if (query.isUnion()) {
                SelectUnion union = (SelectUnion)query;
                return this.collectJoinBatches(union.getLeft()) && this.collectJoinBatches(union.getRight());
            }
            Select select = (Select)query;
            JoinBatch jb = select.getJoinBatch();
            if (jb == null) {
                this.onlyBatchedQueries = false;
            } else {
                if (jb.getLookupBatch(0) == null) {
                    return false;
                }
                assert (!jb.batchedSubQuery);
                jb.batchedSubQuery = true;
                if (this.joinBatches == null) {
                    this.joinBatches = New.arrayList();
                    this.filters = New.arrayList();
                }
                this.filters.add(jb.filters[0]);
                this.joinBatches.add(jb);
            }
            return true;
        }

        @Override
        public boolean isBatchFull() {
            for (int i = 0; i < this.filters.size(); ++i) {
                if (!this.filters.get(i).isBatchFull()) continue;
                return true;
            }
            return false;
        }

        @Override
        protected boolean collectSearchRows(QueryRunnerUnion r) {
            boolean collected = false;
            for (int i = 0; i < this.filters.size(); ++i) {
                if (this.filters.get(i).collectSearchRows()) {
                    collected = true;
                    continue;
                }
                r.topFutureCursors[i] = EMPTY_FUTURE_CURSOR;
            }
            return collected || !this.onlyBatchedQueries;
        }

        @Override
        protected QueryRunnerUnion newQueryRunner() {
            return new QueryRunnerUnion(this);
        }

        @Override
        protected void startQueryRunners(int resultSize) {
            for (int f = 0; f < this.filters.size(); ++f) {
                int r;
                List<Future<Cursor>> topFutureCursors = this.filters.get(f).find();
                int c = 0;
                for (r = 0; r < resultSize; ++r) {
                    Future<Cursor>[] cs = ((QueryRunnerUnion)this.queryRunner((int)r)).topFutureCursors;
                    if (cs[f] != null) continue;
                    cs[f] = topFutureCursors.get(c++);
                }
                assert (r == resultSize);
                assert (c == topFutureCursors.size());
            }
        }
    }

    private final class QueryRunner
    extends QueryRunnerBase {
        Future<Cursor> topFutureCursor;

        public QueryRunner(ViewIndex viewIndex) {
            super(viewIndex);
        }

        @Override
        protected void clear() {
            super.clear();
            this.topFutureCursor = null;
        }

        @Override
        protected Cursor run() throws Exception {
            LocalResult localResult;
            if (this.topFutureCursor == null) {
                return EMPTY_CURSOR;
            }
            this.viewIndex.setupQueryParameters(this.viewIndex.getSession(), this.first, this.last, null);
            JoinBatch.this.viewTopFutureCursor = this.topFutureCursor;
            try {
                localResult = this.viewIndex.getQuery().query(0);
            }
            finally {
                JoinBatch.this.viewTopFutureCursor = null;
            }
            return this.newCursor(localResult);
        }
    }

    private final class ViewIndexLookupBatch
    extends ViewIndexLookupBatchBase<QueryRunner> {
        ViewIndexLookupBatch(ViewIndex viewIndex) {
            super(viewIndex);
        }

        @Override
        protected QueryRunner newQueryRunner() {
            return new QueryRunner(this.viewIndex);
        }

        @Override
        protected boolean collectSearchRows(QueryRunner r) {
            return JoinBatch.this.top.collectSearchRows();
        }

        @Override
        public boolean isBatchFull() {
            return JoinBatch.this.top.isBatchFull();
        }

        @Override
        protected void startQueryRunners(int resultSize) {
            List<Future<Cursor>> topFutureCursors = JoinBatch.this.top.find();
            if (topFutureCursors.size() != resultSize) {
                throw DbException.throwInternalError("Unexpected result size: " + topFutureCursors.size() + ", expected :" + resultSize);
            }
            for (int i = 0; i < resultSize; ++i) {
                QueryRunner r = (QueryRunner)this.queryRunner(i);
                r.topFutureCursor = topFutureCursors.get(i);
            }
        }
    }

    private static abstract class QueryRunnerBase
    extends LazyFuture<Cursor> {
        protected final ViewIndex viewIndex;
        protected SearchRow first;
        protected SearchRow last;

        public QueryRunnerBase(ViewIndex viewIndex) {
            this.viewIndex = viewIndex;
        }

        protected void clear() {
            this.last = null;
            this.first = null;
        }

        @Override
        public final boolean reset() {
            if (super.reset()) {
                return true;
            }
            this.clear();
            return false;
        }

        protected final ViewCursor newCursor(LocalResult localResult) {
            ViewCursor cursor = new ViewCursor(this.viewIndex, localResult, this.first, this.last);
            this.clear();
            return cursor;
        }
    }

    private static abstract class ViewIndexLookupBatchBase<R extends QueryRunnerBase>
    implements IndexLookupBatch {
        protected final ViewIndex viewIndex;
        private final ArrayList<Future<Cursor>> result = New.arrayList();
        private int resultSize;
        private boolean findCalled;

        protected ViewIndexLookupBatchBase(ViewIndex viewIndex) {
            this.viewIndex = viewIndex;
        }

        @Override
        public String getPlanSQL() {
            return "view";
        }

        protected abstract boolean collectSearchRows(R var1);

        protected abstract R newQueryRunner();

        protected abstract void startQueryRunners(int var1);

        protected final boolean resetAfterFind() {
            if (!this.findCalled) {
                return false;
            }
            this.findCalled = false;
            for (int i = 0; i < this.resultSize; ++i) {
                ((QueryRunnerBase)this.queryRunner(i)).reset();
            }
            this.resultSize = 0;
            return true;
        }

        protected R queryRunner(int i) {
            return (R)((QueryRunnerBase)this.result.get(i));
        }

        @Override
        public final boolean addSearchRows(SearchRow first, SearchRow last) {
            R r;
            this.resetAfterFind();
            this.viewIndex.setupQueryParameters(this.viewIndex.getSession(), first, last, null);
            if (this.resultSize < this.result.size()) {
                r = this.queryRunner(this.resultSize);
            } else {
                r = this.newQueryRunner();
                this.result.add((Future<Cursor>)r);
            }
            ((QueryRunnerBase)r).first = first;
            ((QueryRunnerBase)r).last = last;
            if (!this.collectSearchRows(r)) {
                ((QueryRunnerBase)r).clear();
                return false;
            }
            ++this.resultSize;
            return true;
        }

        @Override
        public void reset(boolean beforeQuery) {
            if (this.resultSize != 0 && !this.resetAfterFind()) {
                for (int i = 0; i < this.resultSize; ++i) {
                    ((QueryRunnerBase)this.queryRunner(i)).clear();
                }
                this.resultSize = 0;
            }
        }

        @Override
        public final List<Future<Cursor>> find() {
            if (this.resultSize == 0) {
                return Collections.emptyList();
            }
            this.findCalled = true;
            this.startQueryRunners(this.resultSize);
            return this.resultSize == this.result.size() ? this.result : this.result.subList(0, this.resultSize);
        }
    }

    static final class SingletonList<E>
    extends AbstractList<E> {
        private E element;

        SingletonList() {
        }

        @Override
        public E get(int index) {
            assert (index == 0);
            return this.element;
        }

        @Override
        public E set(int index, E element) {
            assert (index == 0);
            this.element = element;
            return null;
        }

        @Override
        public int size() {
            return 1;
        }
    }

    private static final class FakeLookupBatch
    implements IndexLookupBatch {
        private final TableFilter filter;
        private SearchRow first;
        private SearchRow last;
        private boolean full;
        private final List<Future<Cursor>> result = new SingletonList<Future<Cursor>>();

        FakeLookupBatch(TableFilter filter) {
            this.filter = filter;
        }

        @Override
        public String getPlanSQL() {
            return "fake";
        }

        @Override
        public void reset(boolean beforeQuery) {
            this.full = false;
            this.last = null;
            this.first = null;
            this.result.set(0, null);
        }

        @Override
        public boolean addSearchRows(SearchRow first, SearchRow last) {
            assert (!this.full);
            this.first = first;
            this.last = last;
            this.full = true;
            return true;
        }

        @Override
        public boolean isBatchFull() {
            return this.full;
        }

        @Override
        public List<Future<Cursor>> find() {
            if (!this.full) {
                return Collections.emptyList();
            }
            Cursor c = this.filter.getIndex().find(this.filter, this.first, this.last);
            this.result.set(0, new DoneFuture<Cursor>(c));
            this.full = false;
            this.last = null;
            this.first = null;
            return this.result;
        }
    }

    private static final class JoinRow {
        private static final long S_NULL = 0L;
        private static final long S_FUTURE = 1L;
        private static final long S_CURSOR = 2L;
        private static final long S_ROW = 3L;
        private static final long S_MASK = 3L;
        JoinRow prev;
        JoinRow next;
        private Object[] row;
        private long state;

        JoinRow(Object[] row) {
            this.row = row;
        }

        private long getState(int joinFilterId) {
            return this.state >>> (joinFilterId << 1) & 3L;
        }

        private void incrementState(int joinFilterId, long i) {
            assert (i > 0L) : i;
            this.state += i << (joinFilterId << 1);
        }

        void updateRow(int joinFilterId, Object x, long oldState, long newState) {
            assert (this.getState(joinFilterId) == oldState) : "old state: " + this.getState(joinFilterId);
            this.row[joinFilterId] = x;
            this.incrementState(joinFilterId, newState - oldState);
            assert (this.getState(joinFilterId) == newState) : "new state: " + this.getState(joinFilterId);
        }

        Object row(int joinFilterId) {
            return this.row[joinFilterId];
        }

        boolean isRow(int joinFilterId) {
            return this.getState(joinFilterId) == 3L;
        }

        boolean isFuture(int joinFilterId) {
            return this.getState(joinFilterId) == 1L;
        }

        private boolean isCursor(int joinFilterId) {
            return this.getState(joinFilterId) == 2L;
        }

        boolean isComplete() {
            return this.isRow(this.row.length - 1);
        }

        boolean isDropped() {
            return this.row == null;
        }

        void drop() {
            if (this.prev != null) {
                this.prev.next = this.next;
            }
            if (this.next != null) {
                this.next.prev = this.prev;
            }
            this.row = null;
        }

        JoinRow copyBehind(int jfId) {
            assert (this.isCursor(jfId));
            assert (jfId + 1 == this.row.length || this.row[jfId + 1] == null);
            Object[] r = new Object[this.row.length];
            if (jfId != 0) {
                System.arraycopy(this.row, 0, r, 0, jfId);
            }
            JoinRow copy = new JoinRow(r);
            copy.state = this.state;
            if (this.prev != null) {
                copy.prev = this.prev;
                this.prev.next = copy;
            }
            this.prev = copy;
            copy.next = this;
            return copy;
        }

        public String toString() {
            return "JoinRow->" + Arrays.toString(this.row);
        }
    }

    private static final class JoinFilter {
        final IndexLookupBatch lookupBatch;
        final int id;
        final JoinFilter join;
        final TableFilter filter;

        JoinFilter(IndexLookupBatch lookupBatch, TableFilter filter, JoinFilter join) {
            this.filter = filter;
            this.id = filter.getJoinFilterId();
            this.join = join;
            this.lookupBatch = lookupBatch;
            assert (lookupBatch != null || this.id == 0);
        }

        void reset(boolean beforeQuery) {
            if (this.lookupBatch != null) {
                this.lookupBatch.reset(beforeQuery);
            }
        }

        Row getNullRow() {
            return this.filter.getTable().getNullRow();
        }

        boolean isOuterJoin() {
            return this.filter.isJoinOuter();
        }

        boolean isBatchFull() {
            return this.lookupBatch.isBatchFull();
        }

        boolean isOk(boolean ignoreJoinCondition) {
            boolean filterOk = this.filter.isOk(this.filter.getFilterCondition());
            boolean joinOk = this.filter.isOk(this.filter.getJoinCondition());
            return filterOk && (ignoreJoinCondition || joinOk);
        }

        boolean collectSearchRows() {
            assert (!this.isBatchFull());
            IndexCursor c = this.filter.getIndexCursor();
            c.prepare(this.filter.getSession(), this.filter.getIndexConditions());
            if (c.isAlwaysFalse()) {
                return false;
            }
            return this.lookupBatch.addSearchRows(c.getStart(), c.getEnd());
        }

        List<Future<Cursor>> find() {
            return this.lookupBatch.find();
        }

        JoinRow find(JoinRow current) {
            assert (current != null);
            List<Future<Cursor>> result = this.lookupBatch.find();
            int i = result.size();
            while (i > 0) {
                Future<Cursor> future;
                assert (current.isRow(this.id - 1));
                if (current.row(this.id) == EMPTY_CURSOR) {
                    current = current.prev;
                    continue;
                }
                assert (current.row(this.id) == null);
                if ((future = result.get(--i)) == null) {
                    current.updateRow(this.id, EMPTY_CURSOR, 0L, 2L);
                } else {
                    current.updateRow(this.id, future, 0L, 1L);
                }
                if (current.prev == null || i == 0) break;
                current = current.prev;
            }
            while (current.prev != null && current.prev.row(this.id) == EMPTY_CURSOR) {
                current = current.prev;
            }
            assert (current.prev == null || current.prev.isRow(this.id));
            assert (current.row(this.id) != null);
            assert (!current.isRow(this.id));
            return current;
        }

        public String toString() {
            return "JoinFilter->" + this.filter;
        }
    }
}

