/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import org.h2.mvstore.db.MVTable;

public class ThreadDeadlockDetector {
    private static final String INDENT = "    ";
    private static ThreadDeadlockDetector detector;
    private final ThreadMXBean threadBean;
    private final Timer threadCheck = new Timer("ThreadDeadlockDetector", true);

    private ThreadDeadlockDetector() {
        this.threadBean = ManagementFactory.getThreadMXBean();
        this.threadCheck.schedule(new TimerTask(){

            @Override
            public void run() {
                ThreadDeadlockDetector.this.checkForDeadlocks();
            }
        }, 10L, 10000L);
    }

    public static synchronized void init() {
        if (detector == null) {
            detector = new ThreadDeadlockDetector();
        }
    }

    void checkForDeadlocks() {
        long[] ids = this.threadBean.findDeadlockedThreads();
        if (ids == null) {
            return;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter print = new PrintWriter(stringWriter);
        print.println("ThreadDeadlockDetector - deadlock found :");
        ThreadInfo[] infos = this.threadBean.getThreadInfo(ids, true, true);
        HashMap<Long, String> tableWaitingForLockMap = MVTable.WAITING_FOR_LOCK.getSnapshotOfAllThreads();
        HashMap<Long, ArrayList<String>> tableExclusiveLocksMap = MVTable.EXCLUSIVE_LOCKS.getSnapshotOfAllThreads();
        HashMap<Long, ArrayList<String>> tableSharedLocksMap = MVTable.SHARED_LOCKS.getSnapshotOfAllThreads();
        for (ThreadInfo ti : infos) {
            ThreadDeadlockDetector.printThreadInfo(print, ti);
            ThreadDeadlockDetector.printLockInfo(print, ti.getLockedSynchronizers(), tableWaitingForLockMap.get(ti.getThreadId()), tableExclusiveLocksMap.get(ti.getThreadId()), tableSharedLocksMap.get(ti.getThreadId()));
        }
        print.flush();
        System.out.println(stringWriter.getBuffer());
    }

    private static void printThreadInfo(PrintWriter print, ThreadInfo ti) {
        ThreadDeadlockDetector.printThread(print, ti);
        StackTraceElement[] stackTrace = ti.getStackTrace();
        MonitorInfo[] monitors = ti.getLockedMonitors();
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement e = stackTrace[i];
            print.println("    at " + e.toString());
            for (MonitorInfo mi : monitors) {
                if (mi.getLockedStackDepth() != i) continue;
                print.println("      - locked " + mi);
            }
        }
        print.println();
    }

    private static void printThread(PrintWriter print, ThreadInfo ti) {
        print.print("\"" + ti.getThreadName() + "\"" + " Id=" + ti.getThreadId() + " in " + (Object)((Object)ti.getThreadState()));
        if (ti.getLockName() != null) {
            print.append(" on lock=" + ti.getLockName());
        }
        if (ti.isSuspended()) {
            print.append(" (suspended)");
        }
        if (ti.isInNative()) {
            print.append(" (running in native)");
        }
        print.println();
        if (ti.getLockOwnerName() != null) {
            print.println("     owned by " + ti.getLockOwnerName() + " Id=" + ti.getLockOwnerId());
        }
    }

    private static void printLockInfo(PrintWriter print, LockInfo[] locks, String tableWaitingForLock, ArrayList<String> tableExclusiveLocks, ArrayList<String> tableSharedLocksMap) {
        print.println("    Locked synchronizers: count = " + locks.length);
        for (LockInfo li : locks) {
            print.println("      - " + li);
        }
        if (tableWaitingForLock != null) {
            print.println("    Waiting for table: " + tableWaitingForLock);
        }
        if (tableExclusiveLocks != null) {
            print.println("    Exclusive table locks: count = " + tableExclusiveLocks.size());
            for (String name : tableExclusiveLocks) {
                print.println("      - " + name);
            }
        }
        if (tableSharedLocksMap != null) {
            print.println("    Shared table locks: count = " + tableSharedLocksMap.size());
            for (String name : tableSharedLocksMap) {
                print.println("      - " + name);
            }
        }
        print.println();
    }
}

