/*
 * Decompiled with CFR 0.152.
 */
package waffle.apache;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.commons.logging.LogFactory;
import waffle.apache.GenericWindowsPrincipal;
import waffle.apache.WaffleAuthenticatorBase;
import waffle.util.AuthorizationHeader;
import waffle.util.Base64;
import waffle.util.NtlmServletRequest;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.IWindowsSecurityContext;

public class MixedAuthenticator
extends WaffleAuthenticatorBase {
    public MixedAuthenticator() {
        this._log = LogFactory.getLog(MixedAuthenticator.class);
        this._info = "waffle.apache.MixedAuthenticator/1.0";
        this._log.debug((Object)"[waffle.apache.MixedAuthenticator] loaded");
    }

    public void start() {
        this._log.info((Object)"[waffle.apache.MixedAuthenticator] started");
    }

    public void stop() {
        this._log.info((Object)"[waffle.apache.MixedAuthenticator] stopped");
    }

    protected boolean authenticate(Request request, Response response, LoginConfig loginConfig) {
        if (this.context == null || this.context.getRealm() == null) {
            this._log.warn((Object)"missing context/realm");
            this.sendError(response, 503);
            return false;
        }
        this._log.debug((Object)(request.getMethod() + " " + request.getRequestURI() + ", contentlength: " + request.getContentLength()));
        boolean bl = request.getParameter("j_negotiate_check") != null;
        this._log.debug((Object)("negotiateCheck: " + bl));
        boolean bl2 = request.getParameter("j_security_check") != null;
        this._log.debug((Object)("securityCheck: " + bl2));
        Principal principal = request.getUserPrincipal();
        AuthorizationHeader authorizationHeader = new AuthorizationHeader((HttpServletRequest)request);
        boolean bl3 = authorizationHeader.isNtlmType1PostAuthorizationHeader();
        this._log.debug((Object)("authorization: " + authorizationHeader.toString() + ", ntlm post: " + bl3));
        if (principal != null && !bl3) {
            this._log.debug((Object)("previously authenticated user: " + principal.getName()));
            return true;
        }
        if (bl) {
            if (!authorizationHeader.isNull()) {
                return this.negotiate(request, response, authorizationHeader);
            }
            this._log.debug((Object)"authorization required");
            this.sendUnauthorized(response);
            return false;
        }
        if (bl2) {
            boolean bl4 = this.post(request, response, loginConfig);
            if (bl4) {
                this.redirectTo(request, response, request.getServletPath());
            } else {
                this.redirectTo(request, response, loginConfig.getErrorPage());
            }
            return bl4;
        }
        this.redirectTo(request, response, loginConfig.getLoginPage());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean negotiate(Request request, Response response, AuthorizationHeader authorizationHeader) {
        String string;
        Object object;
        Object object2;
        String string2 = authorizationHeader.getSecurityPackage();
        String string3 = NtlmServletRequest.getConnectionId((HttpServletRequest)request);
        this._log.debug((Object)("security package: " + string2 + ", connection id: " + string3));
        boolean bl = authorizationHeader.isNtlmType1PostAuthorizationHeader();
        if (bl) {
            this._auth.resetSecurityToken(string3);
        }
        IWindowsSecurityContext iWindowsSecurityContext = null;
        try {
            object2 = authorizationHeader.getTokenBytes();
            this._log.debug((Object)("token buffer: " + ((byte[])object2).length + " byte(s)"));
            iWindowsSecurityContext = this._auth.acceptSecurityToken(string3, (byte[])object2, string2);
            this._log.debug((Object)("continue required: " + iWindowsSecurityContext.getContinue()));
            object = iWindowsSecurityContext.getToken();
            if (object != null) {
                string = new String(Base64.encode((byte[])object));
                this._log.debug((Object)("continue token: " + string));
                response.addHeader("WWW-Authenticate", string2 + " " + string);
            }
            if (iWindowsSecurityContext.getContinue() || bl) {
                response.setHeader("Connection", "keep-alive");
                response.sendError(401);
                response.flushBuffer();
                return false;
            }
        }
        catch (Exception exception) {
            this._log.warn((Object)("error logging in user: " + exception.getMessage()));
            this.sendUnauthorized(response);
            return false;
        }
        object2 = iWindowsSecurityContext.getIdentity();
        if (!this._allowGuestLogin && object2.isGuest()) {
            this._log.warn((Object)("guest login disabled: " + object2.getFqn()));
            this.sendUnauthorized(response);
            return false;
        }
        try {
            this._log.debug((Object)("logged in user: " + object2.getFqn() + " (" + object2.getSidString() + ")"));
            object = (Object)new GenericWindowsPrincipal((IWindowsIdentity)object2, this.context.getRealm(), this._principalFormat, this._roleFormat);
            this._log.debug((Object)("roles: " + ((GenericWindowsPrincipal)((Object)object)).getRolesString()));
            string = request.getSession(true);
            this._log.debug((Object)("session id:" + string.getId()));
            this.register(request, response, (Principal)object, string2, object.getName(), null);
            this._log.info((Object)("successfully logged in user: " + object.getName()));
        }
        finally {
            object2.dispose();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean post(Request request, Response response, LoginConfig loginConfig) {
        String string = request.getParameter("j_username");
        String string2 = request.getParameter("j_password");
        this._log.debug((Object)("logging in: " + string));
        IWindowsIdentity iWindowsIdentity = null;
        try {
            iWindowsIdentity = this._auth.logonUser(string, string2);
        }
        catch (Exception exception) {
            this._log.error((Object)exception.getMessage());
            return false;
        }
        if (!this._allowGuestLogin && iWindowsIdentity.isGuest()) {
            this._log.warn((Object)("guest login disabled: " + iWindowsIdentity.getFqn()));
            return false;
        }
        try {
            this._log.debug((Object)("successfully logged in " + string + " (" + iWindowsIdentity.getSidString() + ")"));
            GenericWindowsPrincipal genericWindowsPrincipal = new GenericWindowsPrincipal(iWindowsIdentity, this.context.getRealm(), this._principalFormat, this._roleFormat);
            this._log.debug((Object)("roles: " + genericWindowsPrincipal.getRolesString()));
            HttpSession httpSession = request.getSession(true);
            this._log.debug((Object)("session id:" + httpSession.getId()));
            this.register(request, response, (Principal)((Object)genericWindowsPrincipal), "FORM", genericWindowsPrincipal.getName(), null);
            this._log.info((Object)("successfully logged in user: " + genericWindowsPrincipal.getName()));
        }
        finally {
            iWindowsIdentity.dispose();
        }
        return true;
    }

    private void redirectTo(Request request, Response response, String string) {
        try {
            this._log.debug((Object)("redirecting to: " + string));
            ServletContext servletContext = this.context.getServletContext();
            RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(string);
            requestDispatcher.forward((ServletRequest)request.getRequest(), (ServletResponse)response);
        }
        catch (IOException iOException) {
            this._log.error((Object)iOException.getMessage());
            throw new RuntimeException(iOException);
        }
        catch (ServletException servletException) {
            this._log.error((Object)servletException.getMessage());
            throw new RuntimeException(servletException);
        }
    }
}

