/*
 * Decompiled with CFR 0.152.
 */
package waffle.servlet.spi;

import java.io.IOException;
import java.security.InvalidParameterException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import waffle.servlet.spi.SecurityFilterProvider;
import waffle.util.AuthorizationHeader;
import waffle.windows.auth.IWindowsAuthProvider;
import waffle.windows.auth.IWindowsIdentity;

public class BasicSecurityFilterProvider
implements SecurityFilterProvider {
    private Log _log = LogFactory.getLog(BasicSecurityFilterProvider.class);
    private String _realm = "BasicSecurityFilterProvider";
    private IWindowsAuthProvider _auth = null;

    public BasicSecurityFilterProvider(IWindowsAuthProvider iWindowsAuthProvider) {
        this._auth = iWindowsAuthProvider;
    }

    public IWindowsIdentity doFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        AuthorizationHeader authorizationHeader = new AuthorizationHeader(httpServletRequest);
        String string = new String(authorizationHeader.getTokenBytes());
        String[] stringArray = string.split(":", 2);
        if (stringArray.length != 2) {
            throw new RuntimeException("Invalid username:password in Authorization header.");
        }
        this._log.debug((Object)("logging in user: " + stringArray[0]));
        return this._auth.logonUser(stringArray[0], stringArray[1]);
    }

    public boolean isPrincipalException(HttpServletRequest httpServletRequest) {
        return false;
    }

    public boolean isSecurityPackageSupported(String string) {
        return string.equalsIgnoreCase("Basic");
    }

    public void sendUnauthorized(HttpServletResponse httpServletResponse) {
        httpServletResponse.addHeader("WWW-Authenticate", "Basic realm=\"" + this._realm + "\"");
    }

    public String getRealm() {
        return this._realm;
    }

    public void setRealm(String string) {
        this._realm = string;
    }

    public void initParameter(String string, String string2) {
        if (!string.equals("realm")) {
            throw new InvalidParameterException(string);
        }
        this.setRealm(string2);
    }
}

