/*
 * Decompiled with CFR 0.152.
 */
package waffle.spring;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;
import waffle.servlet.WindowsPrincipal;
import waffle.servlet.spi.SecurityFilterProviderCollection;
import waffle.spring.GrantedAuthorityFactory;
import waffle.spring.WindowsAuthenticationToken;
import waffle.util.AuthorizationHeader;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.PrincipalFormat;

public class NegotiateSecurityFilter
extends GenericFilterBean {
    private Log _log = LogFactory.getLog(NegotiateSecurityFilter.class);
    private SecurityFilterProviderCollection _provider = null;
    private PrincipalFormat _principalFormat = PrincipalFormat.fqn;
    private PrincipalFormat _roleFormat = PrincipalFormat.fqn;
    private boolean _allowGuestLogin = true;
    private GrantedAuthorityFactory _grantedAuthorityFactory = WindowsAuthenticationToken.DEFAULT_GRANTED_AUTHORITY_FACTORY;
    private GrantedAuthority _defaultGrantedAuthority = WindowsAuthenticationToken.DEFAULT_GRANTED_AUTHORITY;

    public NegotiateSecurityFilter() {
        this._log.debug((Object)"[waffle.spring.NegotiateSecurityFilter] loaded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        this._log.info((Object)(httpServletRequest.getMethod() + " " + httpServletRequest.getRequestURI() + ", contentlength: " + httpServletRequest.getContentLength()));
        AuthorizationHeader authorizationHeader = new AuthorizationHeader(httpServletRequest);
        if (!authorizationHeader.isNull() && this._provider.isSecurityPackageSupported(authorizationHeader.getSecurityPackage())) {
            IWindowsIdentity iWindowsIdentity = null;
            try {
                iWindowsIdentity = this._provider.doFilter(httpServletRequest, httpServletResponse);
                if (iWindowsIdentity == null) {
                    return;
                }
            }
            catch (Exception exception) {
                this._log.warn((Object)("error logging in user: " + exception.getMessage()));
                this.sendUnauthorized(httpServletResponse, true);
                return;
            }
            if (!this._allowGuestLogin && iWindowsIdentity.isGuest()) {
                this._log.warn((Object)("guest login disabled: " + iWindowsIdentity.getFqn()));
                this.sendUnauthorized(httpServletResponse, true);
                return;
            }
            try {
                this._log.debug((Object)("logged in user: " + iWindowsIdentity.getFqn() + " (" + iWindowsIdentity.getSidString() + ")"));
                WindowsPrincipal windowsPrincipal = new WindowsPrincipal(iWindowsIdentity, this._principalFormat, this._roleFormat);
                this._log.debug((Object)("roles: " + windowsPrincipal.getRolesString()));
                WindowsAuthenticationToken windowsAuthenticationToken = new WindowsAuthenticationToken(windowsPrincipal, this._grantedAuthorityFactory, this._defaultGrantedAuthority);
                SecurityContextHolder.getContext().setAuthentication((Authentication)windowsAuthenticationToken);
                this._log.info((Object)("successfully logged in user: " + iWindowsIdentity.getFqn()));
            }
            finally {
                iWindowsIdentity.dispose();
            }
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    public void afterPropertiesSet() throws ServletException {
        super.afterPropertiesSet();
        if (this._provider == null) {
            throw new ServletException("Missing NegotiateSecurityFilter.Provider");
        }
    }

    private void sendUnauthorized(HttpServletResponse httpServletResponse, boolean bl) {
        try {
            this._provider.sendUnauthorized(httpServletResponse);
            if (bl) {
                httpServletResponse.setHeader("Connection", "close");
            } else {
                httpServletResponse.setHeader("Connection", "keep-alive");
            }
            httpServletResponse.sendError(401);
            httpServletResponse.flushBuffer();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public PrincipalFormat getPrincipalFormat() {
        return this._principalFormat;
    }

    public void setPrincipalFormat(PrincipalFormat principalFormat) {
        this._principalFormat = principalFormat;
    }

    public PrincipalFormat getRoleFormat() {
        return this._roleFormat;
    }

    public void setRoleFormat(PrincipalFormat principalFormat) {
        this._roleFormat = principalFormat;
    }

    public boolean getAllowGuestLogin() {
        return this._allowGuestLogin;
    }

    public void setAllowGuestLogin(boolean bl) {
        this._allowGuestLogin = bl;
    }

    public SecurityFilterProviderCollection getProvider() {
        return this._provider;
    }

    public void setProvider(SecurityFilterProviderCollection securityFilterProviderCollection) {
        this._provider = securityFilterProviderCollection;
    }

    public GrantedAuthorityFactory getGrantedAuthorityFactory() {
        return this._grantedAuthorityFactory;
    }

    public void setGrantedAuthorityFactory(GrantedAuthorityFactory grantedAuthorityFactory) {
        this._grantedAuthorityFactory = grantedAuthorityFactory;
    }

    public GrantedAuthority getDefaultGrantedAuthority() {
        return this._defaultGrantedAuthority;
    }

    public void setDefaultGrantedAuthority(GrantedAuthority grantedAuthority) {
        this._defaultGrantedAuthority = grantedAuthority;
    }
}

