/*
 * Decompiled with CFR 0.152.
 */
package waffle.spring;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import waffle.servlet.spi.SecurityFilterProviderCollection;

public class NegotiateSecurityFilterEntryPoint
implements AuthenticationEntryPoint {
    private Log _log = LogFactory.getLog(NegotiateSecurityFilterEntryPoint.class);
    private SecurityFilterProviderCollection _provider = null;

    public NegotiateSecurityFilterEntryPoint() {
        this._log.debug((Object)"[waffle.spring.NegotiateEntryPoint] loaded");
    }

    public void commence(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AuthenticationException authenticationException) throws IOException, ServletException {
        this._log.debug((Object)"[waffle.spring.NegotiateEntryPoint] commence");
        if (this._provider == null) {
            throw new ServletException("Missing NegotiateEntryPoint.Provider");
        }
        httpServletResponse.setStatus(401);
        httpServletResponse.setHeader("Connection", "keep-alive");
        this._provider.sendUnauthorized(httpServletResponse);
        httpServletResponse.flushBuffer();
    }

    public SecurityFilterProviderCollection getProvider() {
        return this._provider;
    }

    public void setProvider(SecurityFilterProviderCollection securityFilterProviderCollection) {
        this._provider = securityFilterProviderCollection;
    }
}

