/*
 * Decompiled with CFR 0.152.
 */
package waffle.spring;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import waffle.servlet.WindowsPrincipal;
import waffle.spring.GrantedAuthorityFactory;
import waffle.spring.GuestLoginDisabledAuthenticationException;
import waffle.spring.WindowsAuthenticationToken;
import waffle.windows.auth.IWindowsAuthProvider;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.PrincipalFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowsAuthenticationProvider
implements AuthenticationProvider {
    private Log _log = LogFactory.getLog(WindowsAuthenticationProvider.class);
    private PrincipalFormat _principalFormat = PrincipalFormat.fqn;
    private PrincipalFormat _roleFormat = PrincipalFormat.fqn;
    private boolean _allowGuestLogin = true;
    private IWindowsAuthProvider _authProvider = null;
    private GrantedAuthorityFactory _grantedAuthorityFactory = WindowsAuthenticationToken.DEFAULT_GRANTED_AUTHORITY_FACTORY;
    private GrantedAuthority _defaultGrantedAuthority = WindowsAuthenticationToken.DEFAULT_GRANTED_AUTHORITY;

    public WindowsAuthenticationProvider() {
        this._log.debug((Object)"[waffle.spring.WindowsAuthenticationProvider] loaded");
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        try {
            UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = (UsernamePasswordAuthenticationToken)authentication;
            IWindowsIdentity iWindowsIdentity = this._authProvider.logonUser(usernamePasswordAuthenticationToken.getName(), usernamePasswordAuthenticationToken.getCredentials().toString());
            this._log.debug((Object)("logged in user: " + iWindowsIdentity.getFqn() + " (" + iWindowsIdentity.getSidString() + ")"));
            if (!this._allowGuestLogin && iWindowsIdentity.isGuest()) {
                this._log.warn((Object)("guest login disabled: " + iWindowsIdentity.getFqn()));
                throw new GuestLoginDisabledAuthenticationException(iWindowsIdentity.getFqn());
            }
            WindowsPrincipal windowsPrincipal = new WindowsPrincipal(iWindowsIdentity, this._principalFormat, this._roleFormat);
            this._log.debug((Object)("roles: " + windowsPrincipal.getRolesString()));
            WindowsAuthenticationToken windowsAuthenticationToken = new WindowsAuthenticationToken(windowsPrincipal, this._grantedAuthorityFactory, this._defaultGrantedAuthority);
            this._log.info((Object)("successfully logged in user: " + iWindowsIdentity.getFqn()));
            return windowsAuthenticationToken;
        }
        catch (Exception exception) {
            throw new AuthenticationServiceException(exception.getMessage(), (Throwable)exception);
        }
    }

    public boolean supports(Class<? extends Object> clazz) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(clazz);
    }

    public PrincipalFormat getPrincipalFormat() {
        return this._principalFormat;
    }

    public void setPrincipalFormat(PrincipalFormat principalFormat) {
        this._principalFormat = principalFormat;
    }

    public PrincipalFormat getRoleFormat() {
        return this._roleFormat;
    }

    public void setRoleFormat(PrincipalFormat principalFormat) {
        this._roleFormat = principalFormat;
    }

    public boolean getAllowGuestLogin() {
        return this._allowGuestLogin;
    }

    public void setAllowGuestLogin(boolean bl) {
        this._allowGuestLogin = bl;
    }

    public IWindowsAuthProvider getAuthProvider() {
        return this._authProvider;
    }

    public void setAuthProvider(IWindowsAuthProvider iWindowsAuthProvider) {
        this._authProvider = iWindowsAuthProvider;
    }

    public GrantedAuthorityFactory getGrantedAuthorityFactory() {
        return this._grantedAuthorityFactory;
    }

    public void setGrantedAuthorityFactory(GrantedAuthorityFactory grantedAuthorityFactory) {
        this._grantedAuthorityFactory = grantedAuthorityFactory;
    }

    public GrantedAuthority getDefaultGrantedAuthority() {
        return this._defaultGrantedAuthority;
    }

    public void setDefaultGrantedAuthority(GrantedAuthority grantedAuthority) {
        this._defaultGrantedAuthority = grantedAuthority;
    }
}

