/*
 * Decompiled with CFR 0.152.
 */
package waffle.spring;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.GrantedAuthorityImpl;
import waffle.servlet.WindowsPrincipal;
import waffle.spring.FqnGrantedAuthorityFactory;
import waffle.spring.GrantedAuthorityFactory;
import waffle.windows.auth.WindowsAccount;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowsAuthenticationToken
implements Authentication {
    public static final GrantedAuthorityFactory DEFAULT_GRANTED_AUTHORITY_FACTORY = new FqnGrantedAuthorityFactory("ROLE_", true);
    public static final GrantedAuthority DEFAULT_GRANTED_AUTHORITY = new GrantedAuthorityImpl("ROLE_USER");
    private static final long serialVersionUID = 1L;
    private WindowsPrincipal _principal = null;
    private Collection<GrantedAuthority> _authorities = null;

    public WindowsAuthenticationToken(WindowsPrincipal windowsPrincipal) {
        this(windowsPrincipal, DEFAULT_GRANTED_AUTHORITY_FACTORY, DEFAULT_GRANTED_AUTHORITY);
    }

    public WindowsAuthenticationToken(WindowsPrincipal windowsPrincipal, GrantedAuthorityFactory grantedAuthorityFactory, GrantedAuthority grantedAuthority) {
        this._principal = windowsPrincipal;
        this._authorities = new ArrayList<GrantedAuthority>();
        if (grantedAuthority != null) {
            this._authorities.add(grantedAuthority);
        }
        for (WindowsAccount windowsAccount : this._principal.getGroups().values()) {
            this._authorities.add(grantedAuthorityFactory.createGrantedAuthority(windowsAccount));
        }
    }

    public Collection<GrantedAuthority> getAuthorities() {
        return this._authorities;
    }

    public Object getCredentials() {
        return null;
    }

    public Object getDetails() {
        return null;
    }

    public Object getPrincipal() {
        return this._principal;
    }

    public boolean isAuthenticated() {
        return this._principal != null;
    }

    public void setAuthenticated(boolean bl) throws IllegalArgumentException {
        throw new IllegalArgumentException();
    }

    public String getName() {
        return this._principal.getName();
    }
}

