/*
 * Decompiled with CFR 0.152.
 */
package waffle.windows.auth.impl;

import com.google.common.collect.MapMaker;
import com.sun.jna.NativeLong;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Netapi32Util;
import com.sun.jna.platform.win32.Secur32;
import com.sun.jna.platform.win32.Sspi;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.NativeLongByReference;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import waffle.windows.auth.IWindowsAccount;
import waffle.windows.auth.IWindowsAuthProvider;
import waffle.windows.auth.IWindowsComputer;
import waffle.windows.auth.IWindowsDomain;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.IWindowsSecurityContext;
import waffle.windows.auth.impl.WindowsAccountImpl;
import waffle.windows.auth.impl.WindowsComputerImpl;
import waffle.windows.auth.impl.WindowsCredentialsHandleImpl;
import waffle.windows.auth.impl.WindowsDomainImpl;
import waffle.windows.auth.impl.WindowsIdentityImpl;
import waffle.windows.auth.impl.WindowsSecurityContextImpl;

public class WindowsAuthProviderImpl
implements IWindowsAuthProvider {
    ConcurrentMap<String, Sspi.CtxtHandle> _continueContexts = null;

    public WindowsAuthProviderImpl() {
        this(30);
    }

    public WindowsAuthProviderImpl(int n) {
        this._continueContexts = new MapMaker().expiration((long)n, TimeUnit.SECONDS).makeMap();
    }

    public IWindowsSecurityContext acceptSecurityToken(String string, byte[] byArray, String string2) {
        if (byArray == null || byArray.length == 0) {
            this._continueContexts.remove(string);
            throw new Win32Exception(-2146893048);
        }
        WindowsCredentialsHandleImpl windowsCredentialsHandleImpl = new WindowsCredentialsHandleImpl(null, 1, string2);
        windowsCredentialsHandleImpl.initialize();
        Sspi.SecBufferDesc secBufferDesc = new Sspi.SecBufferDesc(2, 12288);
        Sspi.SecBufferDesc secBufferDesc2 = new Sspi.SecBufferDesc(2, byArray);
        NativeLongByReference nativeLongByReference = new NativeLongByReference();
        Sspi.CtxtHandle ctxtHandle = (Sspi.CtxtHandle)this._continueContexts.get(string);
        Sspi.CtxtHandle ctxtHandle2 = new Sspi.CtxtHandle();
        int n = Secur32.INSTANCE.AcceptSecurityContext(windowsCredentialsHandleImpl.getHandle(), ctxtHandle, secBufferDesc2, new NativeLong(2048L), new NativeLong(16L), ctxtHandle2, secBufferDesc, nativeLongByReference, null);
        WindowsSecurityContextImpl windowsSecurityContextImpl = new WindowsSecurityContextImpl();
        windowsSecurityContextImpl.setCredentialsHandle(windowsCredentialsHandleImpl.getHandle());
        windowsSecurityContextImpl.setSecurityPackage(string2);
        windowsSecurityContextImpl.setSecurityContext(ctxtHandle2);
        switch (n) {
            case 0: {
                this._continueContexts.remove(string);
                if (secBufferDesc != null && secBufferDesc.pBuffers != null && secBufferDesc.cBuffers.intValue() == 1 && secBufferDesc.pBuffers[0].cbBuffer.intValue() > 0) {
                    windowsSecurityContextImpl.setToken(secBufferDesc.getBytes());
                }
                windowsSecurityContextImpl.setContinue(false);
                break;
            }
            case 590610: {
                this._continueContexts.put(string, ctxtHandle2);
                windowsSecurityContextImpl.setToken(secBufferDesc.getBytes());
                windowsSecurityContextImpl.setContinue(true);
                break;
            }
            default: {
                windowsSecurityContextImpl.dispose();
                WindowsSecurityContextImpl.dispose(ctxtHandle);
                this._continueContexts.remove(string);
                throw new Win32Exception(n);
            }
        }
        return windowsSecurityContextImpl;
    }

    public IWindowsComputer getCurrentComputer() {
        try {
            return new WindowsComputerImpl(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException(unknownHostException);
        }
    }

    public IWindowsDomain[] getDomains() {
        Netapi32Util.DomainTrust[] domainTrustArray;
        ArrayList<WindowsDomainImpl> arrayList = new ArrayList<WindowsDomainImpl>();
        for (Netapi32Util.DomainTrust domainTrust : domainTrustArray = Netapi32Util.getDomainTrusts()) {
            arrayList.add(new WindowsDomainImpl(domainTrust));
        }
        return arrayList.toArray(new IWindowsDomain[0]);
    }

    public IWindowsIdentity logonDomainUser(String string, String string2, String string3) {
        return this.logonDomainUserEx(string, string2, string3, 3, 0);
    }

    public IWindowsIdentity logonDomainUserEx(String string, String string2, String string3, int n, int n2) {
        WinNT.HANDLEByReference hANDLEByReference = new WinNT.HANDLEByReference();
        if (!Advapi32.INSTANCE.LogonUser(string, string2, string3, n, n2, hANDLEByReference)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return new WindowsIdentityImpl(hANDLEByReference.getValue());
    }

    public IWindowsIdentity logonUser(String string, String string2) {
        String string3 = null;
        String[] stringArray = string.split("\\\\", 2);
        if (stringArray.length == 2) {
            string = stringArray[1];
            string3 = stringArray[0];
        }
        return this.logonDomainUser(string, string3, string2);
    }

    public IWindowsAccount lookupAccount(String string) {
        return new WindowsAccountImpl(string);
    }

    public void resetSecurityToken(String string) {
        this._continueContexts.remove(string);
    }

    public int getContinueContextsSize() {
        return this._continueContexts.size();
    }
}

