/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.sample.workflow;

import java.util.List;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.WorkflowResponse;
import org.wso2.carbon.apimgt.impl.dao.ApiMgtDAO;
import org.wso2.carbon.apimgt.impl.dto.WorkflowDTO;
import org.wso2.carbon.apimgt.impl.workflow.GeneralWorkflowResponse;
import org.wso2.carbon.apimgt.impl.workflow.HttpWorkflowResponse;
import org.wso2.carbon.apimgt.impl.workflow.WorkflowException;
import org.wso2.carbon.apimgt.impl.workflow.WorkflowExecutor;
import org.wso2.carbon.apimgt.impl.workflow.WorkflowStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionCreationSampleWorkflowExecutor
extends WorkflowExecutor {
    public String getWorkflowType() {
        return "AM_SUBSCRIPTION_CREATION";
    }

    public List<WorkflowDTO> getWorkflowDetails(String workflowStatus) throws WorkflowException {
        return null;
    }

    public WorkflowResponse execute(WorkflowDTO workflowDTO) throws WorkflowException {
        super.execute(workflowDTO);
        HttpWorkflowResponse httpworkflowResponse = new HttpWorkflowResponse();
        httpworkflowResponse.setRedirectUrl("http://google.lk");
        httpworkflowResponse.setAdditionalParameters("CallbackUrl", "http://google.lk");
        httpworkflowResponse.setAdditionalParameters("workflowRefId", workflowDTO.getExternalWorkflowReference());
        httpworkflowResponse.setRedirectConfirmationMsg("You will be redirected to http://wso2.com");
        return httpworkflowResponse;
    }

    public WorkflowResponse complete(WorkflowDTO workflowDTO) throws WorkflowException {
        workflowDTO.setUpdatedTime(System.currentTimeMillis());
        super.complete(workflowDTO);
        ApiMgtDAO apiMgtDAO = new ApiMgtDAO();
        if (WorkflowStatus.APPROVED.equals((Object)workflowDTO.getStatus())) {
            try {
                apiMgtDAO.updateSubscriptionStatus(Integer.parseInt(workflowDTO.getWorkflowReference()), "UNBLOCKED");
            }
            catch (APIManagementException e) {
                throw new WorkflowException("Could not complete subscription creation workflow", (Throwable)e);
            }
        }
        if (WorkflowStatus.REJECTED.equals((Object)workflowDTO.getStatus())) {
            try {
                apiMgtDAO.updateSubscriptionStatus(Integer.parseInt(workflowDTO.getWorkflowReference()), "REJECTED");
            }
            catch (APIManagementException e) {
                throw new WorkflowException("Could not complete subscription creation workflow", (Throwable)e);
            }
        }
        return new GeneralWorkflowResponse();
    }
}

