/*
 * Decompiled with CFR 0.152.
 */
package waffle.apache;

import java.io.IOException;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.Response;
import org.apache.commons.logging.Log;
import waffle.windows.auth.IWindowsAuthProvider;
import waffle.windows.auth.PrincipalFormat;
import waffle.windows.auth.impl.WindowsAuthProviderImpl;

abstract class WaffleAuthenticatorBase
extends AuthenticatorBase {
    protected String _info = null;
    protected Log _log = null;
    protected PrincipalFormat _principalFormat = PrincipalFormat.fqn;
    protected PrincipalFormat _roleFormat = PrincipalFormat.fqn;
    protected boolean _allowGuestLogin = true;
    protected IWindowsAuthProvider _auth = new WindowsAuthProviderImpl();

    WaffleAuthenticatorBase() {
    }

    public IWindowsAuthProvider getAuth() {
        return this._auth;
    }

    public void setAuth(IWindowsAuthProvider iWindowsAuthProvider) {
        this._auth = iWindowsAuthProvider;
    }

    public String getInfo() {
        return this._info;
    }

    public void setPrincipalFormat(String string) {
        this._principalFormat = PrincipalFormat.valueOf(string);
        this._log.debug((Object)("principal format: " + (Object)((Object)this._principalFormat)));
    }

    public PrincipalFormat getPrincipalFormat() {
        return this._principalFormat;
    }

    public void setRoleFormat(String string) {
        this._roleFormat = PrincipalFormat.valueOf(string);
        this._log.debug((Object)("role format: " + (Object)((Object)this._roleFormat)));
    }

    public PrincipalFormat getRoleFormat() {
        return this._roleFormat;
    }

    public boolean getAllowGuestLogin() {
        return this._allowGuestLogin;
    }

    public void setAllowGuestLogin(boolean bl) {
        this._allowGuestLogin = bl;
    }

    protected void sendUnauthorized(Response response) {
        try {
            response.addHeader("WWW-Authenticate", "Negotiate");
            response.addHeader("WWW-Authenticate", "NTLM");
            response.setHeader("Connection", "close");
            response.sendError(401);
            response.flushBuffer();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    protected void sendError(Response response, int n) {
        try {
            response.sendError(n);
        }
        catch (IOException iOException) {
            this._log.error((Object)iOException.getMessage());
            throw new RuntimeException(iOException);
        }
    }
}

