/*
 * Decompiled with CFR 0.152.
 */
package waffle.servlet;

import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import waffle.servlet.AutoDisposableWindowsPrincipal;
import waffle.servlet.NegotiateRequestWrapper;
import waffle.servlet.WindowsPrincipal;
import waffle.servlet.spi.SecurityFilterProvider;
import waffle.servlet.spi.SecurityFilterProviderCollection;
import waffle.util.AuthorizationHeader;
import waffle.windows.auth.IWindowsAuthProvider;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.IWindowsImpersonationContext;
import waffle.windows.auth.PrincipalFormat;
import waffle.windows.auth.impl.WindowsAuthProviderImpl;

public class NegotiateSecurityFilter
implements Filter {
    private Log _log = LogFactory.getLog(NegotiateSecurityFilter.class);
    private PrincipalFormat _principalFormat = PrincipalFormat.fqn;
    private PrincipalFormat _roleFormat = PrincipalFormat.fqn;
    private SecurityFilterProviderCollection _providers = null;
    private IWindowsAuthProvider _auth;
    private boolean _allowGuestLogin = true;
    private boolean _impersonate = false;
    private static final String PRINCIPAL_SESSION_KEY = NegotiateSecurityFilter.class.getName() + ".PRINCIPAL";

    public NegotiateSecurityFilter() {
        this._log.debug((Object)"[waffle.servlet.NegotiateSecurityFilter] loaded");
    }

    public void destroy() {
        this._log.info((Object)"[waffle.servlet.NegotiateSecurityFilter] stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        this._log.info((Object)(httpServletRequest.getMethod() + " " + httpServletRequest.getRequestURI() + ", contentlength: " + httpServletRequest.getContentLength()));
        if (this.doFilterPrincipal(httpServletRequest, httpServletResponse, filterChain)) {
            return;
        }
        AuthorizationHeader authorizationHeader = new AuthorizationHeader(httpServletRequest);
        if (!authorizationHeader.isNull()) {
            IWindowsIdentity iWindowsIdentity = null;
            try {
                iWindowsIdentity = this._providers.doFilter(httpServletRequest, httpServletResponse);
                if (iWindowsIdentity == null) {
                    return;
                }
            }
            catch (Exception exception) {
                this._log.warn((Object)("error logging in user: " + exception.getMessage()));
                this.sendUnauthorized(httpServletResponse, true);
                return;
            }
            IWindowsImpersonationContext iWindowsImpersonationContext = null;
            try {
                if (!this._allowGuestLogin && iWindowsIdentity.isGuest()) {
                    this._log.warn((Object)("guest login disabled: " + iWindowsIdentity.getFqn()));
                    this.sendUnauthorized(httpServletResponse, true);
                    return;
                }
                this._log.debug((Object)("logged in user: " + iWindowsIdentity.getFqn() + " (" + iWindowsIdentity.getSidString() + ")"));
                HttpSession httpSession = httpServletRequest.getSession(true);
                if (httpSession == null) {
                    throw new ServletException("Expected HttpSession");
                }
                Subject subject = (Subject)httpSession.getAttribute("javax.security.auth.subject");
                if (subject == null) {
                    subject = new Subject();
                }
                WindowsPrincipal windowsPrincipal = null;
                windowsPrincipal = this._impersonate ? new AutoDisposableWindowsPrincipal(iWindowsIdentity, this._principalFormat, this._roleFormat) : new WindowsPrincipal(iWindowsIdentity, this._principalFormat, this._roleFormat);
                this._log.debug((Object)("roles: " + windowsPrincipal.getRolesString()));
                subject.getPrincipals().add(windowsPrincipal);
                httpSession.setAttribute("javax.security.auth.subject", (Object)subject);
                this._log.info((Object)("successfully logged in user: " + iWindowsIdentity.getFqn()));
                httpServletRequest.getSession().setAttribute(PRINCIPAL_SESSION_KEY, (Object)windowsPrincipal);
                NegotiateRequestWrapper negotiateRequestWrapper = new NegotiateRequestWrapper(httpServletRequest, windowsPrincipal);
                if (this._impersonate) {
                    this._log.debug((Object)"impersonating user");
                    iWindowsImpersonationContext = iWindowsIdentity.impersonate();
                }
                filterChain.doFilter((ServletRequest)negotiateRequestWrapper, (ServletResponse)httpServletResponse);
            }
            finally {
                if (this._impersonate && iWindowsImpersonationContext != null) {
                    this._log.debug((Object)"terminating impersonation");
                    iWindowsImpersonationContext.RevertToSelf();
                } else {
                    iWindowsIdentity.dispose();
                }
            }
            return;
        }
        this._log.info((Object)"authorization required");
        this.sendUnauthorized(httpServletResponse, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doFilterPrincipal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws IOException, ServletException {
        Object object;
        Principal principal = httpServletRequest.getUserPrincipal();
        if (principal == null && (object = httpServletRequest.getSession(false)) != null) {
            principal = (Principal)object.getAttribute(PRINCIPAL_SESSION_KEY);
        }
        if (principal == null) {
            return false;
        }
        if (this._providers.isPrincipalException(httpServletRequest)) {
            return false;
        }
        if (principal instanceof WindowsPrincipal) {
            this._log.info((Object)("previously authenticated Windows user: " + principal.getName()));
            object = (WindowsPrincipal)principal;
            if (this._impersonate && ((WindowsPrincipal)object).getIdentity() == null) {
                return false;
            }
            NegotiateRequestWrapper negotiateRequestWrapper = new NegotiateRequestWrapper(httpServletRequest, (WindowsPrincipal)object);
            IWindowsImpersonationContext iWindowsImpersonationContext = null;
            if (this._impersonate) {
                this._log.debug((Object)"re-impersonating user");
                iWindowsImpersonationContext = ((WindowsPrincipal)object).getIdentity().impersonate();
            }
            try {
                filterChain.doFilter((ServletRequest)negotiateRequestWrapper, (ServletResponse)httpServletResponse);
            }
            finally {
                if (this._impersonate && iWindowsImpersonationContext != null) {
                    this._log.debug((Object)"terminating impersonation");
                    iWindowsImpersonationContext.RevertToSelf();
                }
            }
        } else {
            this._log.info((Object)("previously authenticated user: " + principal.getName()));
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        return true;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String[] stringArray;
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        if (filterConfig != null) {
            Enumeration enumeration = filterConfig.getInitParameterNames();
            while (enumeration.hasMoreElements()) {
                String object = (String)enumeration.nextElement();
                stringArray = filterConfig.getInitParameter(object);
                this._log.debug((Object)(object + "=" + (String)stringArray));
                if (object.equals("principalFormat")) {
                    this._principalFormat = PrincipalFormat.valueOf((String)stringArray);
                    continue;
                }
                if (object.equals("roleFormat")) {
                    this._roleFormat = PrincipalFormat.valueOf((String)stringArray);
                    continue;
                }
                if (object.equals("allowGuestLogin")) {
                    this._allowGuestLogin = Boolean.parseBoolean((String)stringArray);
                    continue;
                }
                if (object.equals("impersonate")) {
                    this._impersonate = Boolean.parseBoolean((String)stringArray);
                    continue;
                }
                if (object.equals("securityFilterProviders")) {
                    stringArray3 = stringArray.split("\\s+");
                    continue;
                }
                if (object.equals("authProvider")) {
                    stringArray2 = stringArray;
                    continue;
                }
                hashMap.put(object, stringArray);
            }
        }
        if (stringArray2 != null) {
            try {
                this._auth = (IWindowsAuthProvider)Class.forName(stringArray2).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                this._log.error((Object)("error loading '" + stringArray2 + "': " + exception.getMessage()));
                throw new ServletException((Throwable)exception);
            }
        }
        if (this._auth == null) {
            this._auth = new WindowsAuthProviderImpl();
        }
        if (stringArray3 != null) {
            this._providers = new SecurityFilterProviderCollection(stringArray3, this._auth);
        }
        if (this._providers == null) {
            this._log.debug((Object)"initializing default security filter providers");
            this._providers = new SecurityFilterProviderCollection(this._auth);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            stringArray = ((String)entry.getKey()).split("/", 2);
            if (stringArray.length == 2) {
                try {
                    this._log.debug((Object)("setting " + stringArray[0] + ", " + stringArray[1] + "=" + (String)entry.getValue()));
                    SecurityFilterProvider exception = this._providers.getByClassName(stringArray[0]);
                    exception.initParameter(stringArray[1], (String)entry.getValue());
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this._log.error((Object)("invalid class: " + stringArray[0] + " in " + (String)entry.getKey()));
                    throw new ServletException((Throwable)classNotFoundException);
                }
                catch (Exception exception) {
                    this._log.error((Object)(stringArray[0] + ": error setting '" + stringArray[1] + "': " + exception.getMessage()));
                    throw new ServletException((Throwable)exception);
                }
            }
            this._log.error((Object)("Invalid parameter: " + (String)entry.getKey()));
            throw new ServletException("Invalid parameter: " + (String)entry.getKey());
        }
        this._log.info((Object)"[waffle.servlet.NegotiateSecurityFilter] started");
    }

    public void setPrincipalFormat(String string) {
        this._principalFormat = PrincipalFormat.valueOf(string);
        this._log.info((Object)("principal format: " + (Object)((Object)this._principalFormat)));
    }

    public PrincipalFormat getPrincipalFormat() {
        return this._principalFormat;
    }

    public void setRoleFormat(String string) {
        this._roleFormat = PrincipalFormat.valueOf(string);
        this._log.info((Object)("role format: " + (Object)((Object)this._roleFormat)));
    }

    public PrincipalFormat getRoleFormat() {
        return this._roleFormat;
    }

    private void sendUnauthorized(HttpServletResponse httpServletResponse, boolean bl) {
        try {
            this._providers.sendUnauthorized(httpServletResponse);
            if (bl) {
                httpServletResponse.setHeader("Connection", "close");
            } else {
                httpServletResponse.setHeader("Connection", "keep-alive");
            }
            httpServletResponse.sendError(401);
            httpServletResponse.flushBuffer();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public IWindowsAuthProvider getAuth() {
        return this._auth;
    }

    public void setAuth(IWindowsAuthProvider iWindowsAuthProvider) {
        this._auth = iWindowsAuthProvider;
    }

    public boolean getAllowGuestLogin() {
        return this._allowGuestLogin;
    }

    public void setImpersonate(boolean bl) {
        this._impersonate = bl;
    }

    public boolean getImpersonate() {
        return this._impersonate;
    }

    public SecurityFilterProviderCollection getProviders() {
        return this._providers;
    }
}

