/*
 * Decompiled with CFR 0.152.
 */
package waffle.util;

import javax.servlet.http.HttpServletRequest;
import waffle.util.Base64;
import waffle.util.NtlmMessage;

public class AuthorizationHeader {
    private HttpServletRequest _request;

    public AuthorizationHeader(HttpServletRequest httpServletRequest) {
        this._request = httpServletRequest;
    }

    public String getHeader() {
        return this._request.getHeader("Authorization");
    }

    public boolean isNull() {
        String string = this.getHeader();
        return string == null || string.length() == 0;
    }

    public String getSecurityPackage() {
        String string = this.getHeader();
        if (string == null) {
            throw new RuntimeException("Missing Authorization: header");
        }
        int n = string.indexOf(32);
        if (n > 0) {
            return string.substring(0, n);
        }
        throw new RuntimeException("Invalid Authorization header: " + string);
    }

    public String toString() {
        return this.isNull() ? "<none>" : this.getHeader();
    }

    public String getToken() {
        return this.getHeader().substring(this.getSecurityPackage().length() + 1);
    }

    public byte[] getTokenBytes() {
        return Base64.decode(this.getToken());
    }

    public boolean isNtlmType1Message() {
        if (this.isNull()) {
            return false;
        }
        byte[] byArray = this.getTokenBytes();
        if (!NtlmMessage.isNtlmMessage(byArray)) {
            return false;
        }
        return 1 == NtlmMessage.getMessageType(byArray);
    }

    public boolean isNtlmType1PostAuthorizationHeader() {
        if (!this._request.getMethod().equals("POST") && !this._request.getMethod().equals("PUT")) {
            return false;
        }
        if (this._request.getContentLength() != 0) {
            return false;
        }
        return this.isNtlmType1Message();
    }
}

