/*
 * Decompiled with CFR 0.152.
 */
package waffle.windows.auth.impl;

import com.sun.jna.NativeLong;
import com.sun.jna.platform.win32.Secur32;
import com.sun.jna.platform.win32.Sspi;
import com.sun.jna.platform.win32.Win32Exception;
import waffle.windows.auth.IWindowsCredentialsHandle;

public class WindowsCredentialsHandleImpl
implements IWindowsCredentialsHandle {
    private String _principalName = null;
    private NativeLong _credentialsType = null;
    private String _securityPackage = null;
    private Sspi.CredHandle _handle = null;
    private Sspi.TimeStamp _clientLifetime = null;

    public static IWindowsCredentialsHandle getCurrent(String string) {
        WindowsCredentialsHandleImpl windowsCredentialsHandleImpl = new WindowsCredentialsHandleImpl(null, 2, string);
        windowsCredentialsHandleImpl.initialize();
        return windowsCredentialsHandleImpl;
    }

    public WindowsCredentialsHandleImpl(String string, int n, String string2) {
        this._principalName = string;
        this._credentialsType = new NativeLong((long)n);
        this._securityPackage = string2;
    }

    public void initialize() {
        this._handle = new Sspi.CredHandle();
        this._clientLifetime = new Sspi.TimeStamp();
        int n = Secur32.INSTANCE.AcquireCredentialsHandle(this._principalName, this._securityPackage, this._credentialsType, null, null, null, null, this._handle, this._clientLifetime);
        if (0 != n) {
            throw new Win32Exception(n);
        }
    }

    public void dispose() {
        if (this._handle != null && !this._handle.isNull()) {
            int n = Secur32.INSTANCE.FreeCredentialsHandle(this._handle);
            if (0 != n) {
                throw new Win32Exception(n);
            }
            this._handle = null;
        }
    }

    public Sspi.CredHandle getHandle() {
        return this._handle;
    }
}

