/*
 * Decompiled with CFR 0.152.
 */
package waffle.windows.auth.impl;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import java.util.ArrayList;
import waffle.windows.auth.IWindowsAccount;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.IWindowsImpersonationContext;
import waffle.windows.auth.impl.WindowsAccountImpl;
import waffle.windows.auth.impl.WindowsIdentityImpersonationContextImpl;

public class WindowsIdentityImpl
implements IWindowsIdentity {
    private WinNT.HANDLE _windowsIdentity = null;
    private Advapi32Util.Account[] _userGroups = null;
    private Advapi32Util.Account _windowsAccount = null;

    private Advapi32Util.Account getWindowsAccount() {
        if (this._windowsAccount == null) {
            this._windowsAccount = Advapi32Util.getTokenAccount((WinNT.HANDLE)this._windowsIdentity);
        }
        return this._windowsAccount;
    }

    private Advapi32Util.Account[] getUserGroups() {
        if (this._userGroups == null) {
            this._userGroups = Advapi32Util.getTokenGroups((WinNT.HANDLE)this._windowsIdentity);
        }
        return this._userGroups;
    }

    public String getFqn() {
        return this.getWindowsAccount().fqn;
    }

    public IWindowsAccount[] getGroups() {
        Advapi32Util.Account[] accountArray = this.getUserGroups();
        ArrayList<WindowsAccountImpl> arrayList = new ArrayList<WindowsAccountImpl>(accountArray.length);
        for (Advapi32Util.Account account : accountArray) {
            WindowsAccountImpl windowsAccountImpl = new WindowsAccountImpl(account);
            arrayList.add(windowsAccountImpl);
        }
        return arrayList.toArray(new IWindowsAccount[0]);
    }

    public byte[] getSid() {
        return this.getWindowsAccount().sid;
    }

    public String getSidString() {
        return this.getWindowsAccount().sidString;
    }

    public void dispose() {
        if (this._windowsIdentity != null) {
            Kernel32.INSTANCE.CloseHandle(this._windowsIdentity);
            this._windowsIdentity = null;
        }
    }

    public IWindowsImpersonationContext impersonate() {
        return new WindowsIdentityImpersonationContextImpl(this._windowsIdentity);
    }

    public WindowsIdentityImpl(WinNT.HANDLE hANDLE) {
        this._windowsIdentity = hANDLE;
    }

    public boolean isGuest() {
        for (Advapi32Util.Account account : this.getUserGroups()) {
            if (Advapi32Util.isWellKnownSid((byte[])account.sid, (int)28)) {
                return true;
            }
            if (Advapi32Util.isWellKnownSid((byte[])account.sid, (int)43)) {
                return true;
            }
            if (!Advapi32Util.isWellKnownSid((byte[])account.sid, (int)39)) continue;
            return true;
        }
        return Advapi32Util.isWellKnownSid((byte[])this.getSid(), (int)13);
    }
}

