/*
 * Decompiled with CFR 0.152.
 */
package waffle.windows.auth.impl;

import com.sun.jna.NativeLong;
import com.sun.jna.platform.win32.Secur32;
import com.sun.jna.platform.win32.Sspi;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.NativeLongByReference;
import waffle.windows.auth.IWindowsCredentialsHandle;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.IWindowsImpersonationContext;
import waffle.windows.auth.IWindowsSecurityContext;
import waffle.windows.auth.impl.WindowsAccountImpl;
import waffle.windows.auth.impl.WindowsCredentialsHandleImpl;
import waffle.windows.auth.impl.WindowsIdentityImpl;
import waffle.windows.auth.impl.WindowsSecurityContextImpersonationContextImpl;

public class WindowsSecurityContextImpl
implements IWindowsSecurityContext {
    private String _principalName;
    private String _securityPackage;
    private Sspi.SecBufferDesc _token = null;
    private Sspi.CtxtHandle _ctx = null;
    private NativeLongByReference _attr;
    private Sspi.CredHandle _credentials;
    private boolean _continue;

    public IWindowsIdentity getIdentity() {
        WinNT.HANDLEByReference hANDLEByReference = new WinNT.HANDLEByReference();
        int n = Secur32.INSTANCE.QuerySecurityContextToken(this._ctx, hANDLEByReference);
        if (0 != n) {
            throw new Win32Exception(n);
        }
        return new WindowsIdentityImpl(hANDLEByReference.getValue());
    }

    public String getSecurityPackage() {
        return this._securityPackage;
    }

    public byte[] getToken() {
        return this._token == null ? null : this._token.getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IWindowsSecurityContext getCurrent(String string, String string2) {
        IWindowsCredentialsHandle iWindowsCredentialsHandle = WindowsCredentialsHandleImpl.getCurrent(string);
        iWindowsCredentialsHandle.initialize();
        try {
            WindowsSecurityContextImpl windowsSecurityContextImpl = new WindowsSecurityContextImpl();
            windowsSecurityContextImpl.setPrincipalName(WindowsAccountImpl.getCurrentUsername());
            windowsSecurityContextImpl.setCredentialsHandle(iWindowsCredentialsHandle.getHandle());
            windowsSecurityContextImpl.setSecurityPackage(string);
            windowsSecurityContextImpl.initialize(null, null, string2);
            WindowsSecurityContextImpl windowsSecurityContextImpl2 = windowsSecurityContextImpl;
            return windowsSecurityContextImpl2;
        }
        finally {
            iWindowsCredentialsHandle.dispose();
        }
    }

    public void initialize(Sspi.CtxtHandle ctxtHandle, Sspi.SecBufferDesc secBufferDesc, String string) {
        this._attr = new NativeLongByReference();
        this._token = new Sspi.SecBufferDesc(2, 12288);
        this._ctx = new Sspi.CtxtHandle();
        int n = Secur32.INSTANCE.InitializeSecurityContext(this._credentials, ctxtHandle, string, new NativeLong(2048L), new NativeLong(0L), new NativeLong(16L), secBufferDesc, new NativeLong(0L), this._ctx, this._token, this._attr, null);
        switch (n) {
            case 590610: {
                this._continue = true;
                break;
            }
            case 0: {
                this._continue = false;
                break;
            }
            default: {
                throw new Win32Exception(n);
            }
        }
    }

    public void dispose() {
        WindowsSecurityContextImpl.dispose(this._ctx);
    }

    public static boolean dispose(Sspi.CtxtHandle ctxtHandle) {
        if (ctxtHandle != null && !ctxtHandle.isNull()) {
            int n = Secur32.INSTANCE.DeleteSecurityContext(ctxtHandle);
            if (0 != n) {
                throw new Win32Exception(n);
            }
            return true;
        }
        return false;
    }

    public String getPrincipalName() {
        return this._principalName;
    }

    public void setPrincipalName(String string) {
        this._principalName = string;
    }

    public Sspi.CtxtHandle getHandle() {
        return this._ctx;
    }

    public void setCredentialsHandle(Sspi.CredHandle credHandle) {
        this._credentials = credHandle;
    }

    public void setToken(byte[] byArray) {
        this._token = new Sspi.SecBufferDesc(2, byArray);
    }

    public void setSecurityPackage(String string) {
        this._securityPackage = string;
    }

    public void setSecurityContext(Sspi.CtxtHandle ctxtHandle) {
        this._ctx = ctxtHandle;
    }

    public boolean getContinue() {
        return this._continue;
    }

    public void setContinue(boolean bl) {
        this._continue = bl;
    }

    public IWindowsImpersonationContext impersonate() {
        return new WindowsSecurityContextImpersonationContextImpl(this._ctx);
    }
}

