/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.sample.apimgt.workflow;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.WorkflowResponse;
import org.wso2.carbon.apimgt.impl.dao.ApiMgtDAO;
import org.wso2.carbon.apimgt.impl.dto.WorkflowDTO;
import org.wso2.carbon.apimgt.impl.workflow.GeneralWorkflowResponse;
import org.wso2.carbon.apimgt.impl.workflow.SubscriptionCreationWSWorkflowExecutor;
import org.wso2.carbon.apimgt.impl.workflow.WorkflowException;

public class SampleSubscriptionWorkflow
extends SubscriptionCreationWSWorkflowExecutor {
    private static final Log log = LogFactory.getLog(SampleSubscriptionWorkflow.class);

    public WorkflowResponse execute(WorkflowDTO workflowDTO) throws WorkflowException {
        ApiMgtDAO apiMgtDAO = ApiMgtDAO.getInstance();
        try {
            apiMgtDAO.addWorkflowEntry(workflowDTO);
            apiMgtDAO.updateSubscriptionStatus(Integer.parseInt(workflowDTO.getWorkflowReference()), "ON_HOLD");
            log.info((Object)("The subscription with workflow reference: " + workflowDTO.getExternalWorkflowReference() + ", workflow external reference: " + workflowDTO.getExternalWorkflowReference() + " has been put on Hold"));
        }
        catch (APIManagementException e) {
            log.error((Object)"Could not complete subscription creation workflow", (Throwable)e);
            throw new WorkflowException("Could not complete subscription creation workflow", (Throwable)e);
        }
        return new GeneralWorkflowResponse();
    }
}

