ALTER TABLE AM_SUBSCRIPTION_KEY_MAPPING ALTER COLUMN ACCESS_TOKEN SET DATA TYPE VARCHAR(512)
/
ALTER TABLE AM_APPLICATION_REGISTRATION ALTER COLUMN TOKEN_SCOPE SET DATA TYPE VARCHAR(1500)
/
CREATE TABLE AM_CERTIFICATE_METADATA (
  TENANT_ID INT NOT NULL,
  ALIAS VARCHAR(45) NOT NULL,
  END_POINT VARCHAR(100) NOT NULL,
  CONSTRAINT PK_ALIAS PRIMARY KEY (ALIAS),
  CONSTRAINT END_POINT_CONSTRAINT UNIQUE (END_POINT)
) /

CREATE TABLE AM_APPLICATION_GROUP_MAPPING (
    APPLICATION_ID INTEGER NOT NULL,
    GROUP_ID VARCHAR(512)NOT NULL,
    TENANT VARCHAR(255) NOT NULL,
    PRIMARY KEY (APPLICATION_ID,GROUP_ID,TENANT),
    FOREIGN KEY (APPLICATION_ID) REFERENCES AM_APPLICATION(APPLICATION_ID) ON DELETE CASCADE
) /

CREATE TABLE AM_USAGE_UPLOADED_FILES (
  TENANT_DOMAIN varchar(255) NOT NULL,
  FILE_NAME varchar(255) NOT NULL,
  FILE_TIMESTAMP TIMESTAMP(0) NOT NULL DEFAULT CURRENT_TIMESTAMP,
  FILE_PROCESSED SMALLINT NOT NULL DEFAULT 0,
  FILE_CONTENT BLOB DEFAULT NULL,
  PRIMARY KEY (TENANT_DOMAIN, FILE_NAME, FILE_TIMESTAMP)
) /

CREATE TABLE AM_API_LC_PUBLISH_EVENTS (
    ID INTEGER NOT NULL,
    TENANT_DOMAIN VARCHAR(500) NOT NULL,
    API_ID VARCHAR(500) NOT NULL,
    EVENT_TIME TIMESTAMP(0) NOT NULL,
    PRIMARY KEY (ID)
) /
