ALTER TABLE AM_APPLICATION_REGISTRATION MODIFY TOKEN_SCOPE VARCHAR(1500)
/

ALTER TABLE AM_SUBSCRIBER MODIFY USER_ID VARCHAR2(255)
/

CREATE TABLE AM_CERTIFICATE_METADATA (
  TENANT_ID INTEGER NOT NULL,
  ALIAS VARCHAR2(45) NOT NULL,
  END_POINT VARCHAR2(100) NOT NULL,
  CONSTRAINT PK_ALIAS PRIMARY KEY (ALIAS),
  CONSTRAINT END_POINT_CONSTRAINT UNIQUE (END_POINT)
)
/

CREATE TABLE AM_APPLICATION_GROUP_MAPPING (
    APPLICATION_ID INTEGER NOT NULL,
    GROUP_ID VARCHAR2(512) NOT NULL,
    TENANT VARCHAR2 (255),
    PRIMARY KEY (APPLICATION_ID,GROUP_ID,TENANT),
    FOREIGN KEY (APPLICATION_ID) REFERENCES AM_APPLICATION(APPLICATION_ID) ON DELETE CASCADE
)
/

CREATE TABLE AM_USAGE_UPLOADED_FILES (
  TENANT_DOMAIN VARCHAR2 (255) NOT NULL,
  FILE_NAME VARCHAR2 (255) NOT NULL,
  FILE_TIMESTAMP TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  FILE_PROCESSED INTEGER DEFAULT 0,
  FILE_CONTENT BLOB DEFAULT NULL,
  PRIMARY KEY (TENANT_DOMAIN, FILE_NAME, FILE_TIMESTAMP))
/

CREATE TABLE AM_API_LC_PUBLISH_EVENTS (
    ID INTEGER,
    TENANT_DOMAIN VARCHAR2 (500) NOT NULL,
    API_ID VARCHAR2 (500) NOT NULL,
    EVENT_TIME TIMESTAMP NOT NULL,
    PRIMARY KEY (ID)
)
/

CREATE SEQUENCE AM_API_LC_PUBLISH_EVENTS_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/

CREATE OR REPLACE TRIGGER AM_API_LC_PUBLISH_EVENTS_TRIG
            BEFORE INSERT
            ON AM_API_LC_PUBLISH_EVENTS
            REFERENCING NEW AS NEW
            FOR EACH ROW
              BEGIN
                SELECT AM_API_LC_PUBLISH_EVENTS_SEQ.nextval INTO :NEW.ID FROM dual;
              END;
/