DROP TABLE IF EXISTS AM_ALERT_TYPES;

CREATE TABLE AM_ALERT_TYPES (
    ALERT_TYPE_ID INTEGER AUTO_INCREMENT,
    ALERT_TYPE_NAME VARCHAR(255) NOT NULL ,
	STAKE_HOLDER VARCHAR(100) NOT NULL,
    PRIMARY KEY (ALERT_TYPE_ID)
)ENGINE = INNODB;

INSERT INTO AM_ALERT_TYPES (ALERT_TYPE_NAME, STAKE_HOLDER) VALUES ('AbnormalResponseTime', 'publisher');
INSERT INTO AM_ALERT_TYPES (ALERT_TYPE_NAME, STAKE_HOLDER) VALUES ('AbnormalBackendTime', 'publisher');
INSERT INTO AM_ALERT_TYPES (ALERT_TYPE_NAME, STAKE_HOLDER) VALUES ('AbnormalRequestsPerMin', 'subscriber');
INSERT INTO AM_ALERT_TYPES (ALERT_TYPE_NAME, STAKE_HOLDER) VALUES ('AbnormalRequestPattern', 'subscriber');
INSERT INTO AM_ALERT_TYPES (ALERT_TYPE_NAME, STAKE_HOLDER) VALUES ('UnusualIPAccess', 'subscriber');
INSERT INTO AM_ALERT_TYPES (ALERT_TYPE_NAME, STAKE_HOLDER) VALUES ('FrequentTierLimitHitting', 'subscriber');
INSERT INTO AM_ALERT_TYPES (ALERT_TYPE_NAME, STAKE_HOLDER) VALUES ('ApiHealthMonitor', 'publisher');

DELIMITER //
CREATE PROCEDURE DeleteEndPointConstraintIndex()
BEGIN
IF EXISTS ( SELECT * FROM INFORMATION_SCHEMA.STATISTICS  WHERE TABLE_NAME = 'AM_CERTIFICATE_METADATA'
            AND INDEX_NAME = 'END_POINT_CONSTRAINT') THEN
   ALTER TABLE  AM_CERTIFICATE_METADATA DROP INDEX END_POINT_CONSTRAINT;
END IF;
END//
DELIMITER ;
CALL DeleteEndPointConstraintIndex();
DROP PROCEDURE IF EXISTS DeleteEndPointConstraintIndex;
