ALTER TABLE AM_SUBSCRIBER
    ALTER COLUMN DATE_SUBSCRIBED TYPE TIMESTAMP,
    ALTER COLUMN DATE_SUBSCRIBED SET NOT NULL,
    ALTER COLUMN CREATED_TIME TYPE TIMESTAMP,
    ALTER COLUMN UPDATED_TIME TYPE TIMESTAMP;

ALTER TABLE AM_APPLICATION
    ALTER COLUMN CREATED_TIME TYPE TIMESTAMP,
    ALTER COLUMN UPDATED_TIME TYPE TIMESTAMP;

ALTER TABLE AM_API
    ALTER COLUMN CREATED_TIME TYPE TIMESTAMP,
    ALTER COLUMN UPDATED_TIME TYPE TIMESTAMP;

ALTER TABLE AM_SUBSCRIPTION
    ALTER COLUMN LAST_ACCESSED TYPE TIMESTAMP,
    ALTER COLUMN CREATED_TIME TYPE TIMESTAMP,
    ALTER COLUMN UPDATED_TIME TYPE TIMESTAMP;

ALTER TABLE AM_API_LC_EVENT
    ALTER COLUMN EVENT_DATE TYPE TIMESTAMP,
    ALTER COLUMN EVENT_DATE SET NOT NULL;

ALTER TABLE AM_API_COMMENTS
    ALTER COLUMN DATE_COMMENTED TYPE TIMESTAMP,
    ALTER COLUMN DATE_COMMENTED SET NOT NULL;

DROP TABLE IF EXISTS AM_ALERT_TYPES;

DROP SEQUENCE IF EXISTS AM_ALERT_TYPES_SEQ;

CREATE SEQUENCE AM_ALERT_TYPES_SEQ START WITH 1 INCREMENT BY 1;

CREATE TABLE AM_ALERT_TYPES (
    ALERT_TYPE_ID INTEGER DEFAULT NEXTVAL('am_alert_types_seq'),
    ALERT_TYPE_NAME VARCHAR(255) NOT NULL ,
	STAKE_HOLDER VARCHAR(100) NOT NULL,
    PRIMARY KEY (ALERT_TYPE_ID)
);

INSERT INTO AM_ALERT_TYPES (ALERT_TYPE_NAME, STAKE_HOLDER) VALUES ('AbnormalResponseTime', 'publisher');
INSERT INTO AM_ALERT_TYPES (ALERT_TYPE_NAME, STAKE_HOLDER) VALUES ('AbnormalBackendTime', 'publisher');
INSERT INTO AM_ALERT_TYPES (ALERT_TYPE_NAME, STAKE_HOLDER) VALUES ('AbnormalRequestsPerMin', 'subscriber');
INSERT INTO AM_ALERT_TYPES (ALERT_TYPE_NAME, STAKE_HOLDER) VALUES ('AbnormalRequestPattern', 'subscriber');
INSERT INTO AM_ALERT_TYPES (ALERT_TYPE_NAME, STAKE_HOLDER) VALUES ('UnusualIPAccess', 'subscriber');
INSERT INTO AM_ALERT_TYPES (ALERT_TYPE_NAME, STAKE_HOLDER) VALUES ('FrequentTierLimitHitting', 'subscriber');
INSERT INTO AM_ALERT_TYPES (ALERT_TYPE_NAME, STAKE_HOLDER) VALUES ('ApiHealthMonitor', 'publisher');

ALTER TABLE AM_CERTIFICATE_METADATA DROP CONSTRAINT IF EXISTS END_POINT_CONSTRAINT;
