/*
 * WSO2 API Manager - Admin
 * This document specifies a **RESTful API** for WSO2 **API Manager** - Admin Portal. Please see [full swagger definition](https://raw.githubusercontent.com/wso2/carbon-apimgt/v6.1.66/components/apimgt/org.wso2.carbon.apimgt.rest.api.admin/src/main/resources/admin-api.yaml) of the API which is written using [swagger 2.0](http://swagger.io/) specification. 
 *
 * OpenAPI spec version: 0.11.0
 * Contact: architecture@wso2.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.wso2.carbon.apimgt.samples.utils.admin.rest.client.model;

import java.util.Objects;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.wso2.carbon.apimgt.samples.utils.admin.rest.client.model.ThrottleCondition;
import org.wso2.carbon.apimgt.samples.utils.admin.rest.client.model.ThrottleLimit;

/**
 * ConditionalGroup
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2017-11-01T13:06:20.200+05:30")
public class ConditionalGroup {
  @SerializedName("description")
  private String description = null;

  @SerializedName("conditions")
  private List<ThrottleCondition> conditions = new ArrayList<ThrottleCondition>();

  @SerializedName("limit")
  private ThrottleLimit limit = null;

  public ConditionalGroup description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Description of the Conditional Group
   * @return description
  **/
  @ApiModelProperty(example = "null", value = "Description of the Conditional Group")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public ConditionalGroup conditions(List<ThrottleCondition> conditions) {
    this.conditions = conditions;
    return this;
  }

  public ConditionalGroup addConditionsItem(ThrottleCondition conditionsItem) {
    this.conditions.add(conditionsItem);
    return this;
  }

   /**
   * Individual throttling conditions. They can be defined as either HeaderCondition, IPCondition, JWTClaimsCondition, QueryParameterCondition Please see schemas of each of those throttling condition in Definitions section. 
   * @return conditions
  **/
  @ApiModelProperty(example = "&quot;&quot;", required = true, value = "Individual throttling conditions. They can be defined as either HeaderCondition, IPCondition, JWTClaimsCondition, QueryParameterCondition Please see schemas of each of those throttling condition in Definitions section. ")
  public List<ThrottleCondition> getConditions() {
    return conditions;
  }

  public void setConditions(List<ThrottleCondition> conditions) {
    this.conditions = conditions;
  }

  public ConditionalGroup limit(ThrottleLimit limit) {
    this.limit = limit;
    return this;
  }

   /**
   * Get limit
   * @return limit
  **/
  @ApiModelProperty(example = "null", required = true, value = "")
  public ThrottleLimit getLimit() {
    return limit;
  }

  public void setLimit(ThrottleLimit limit) {
    this.limit = limit;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ConditionalGroup conditionalGroup = (ConditionalGroup) o;
    return Objects.equals(this.description, conditionalGroup.description) &&
        Objects.equals(this.conditions, conditionalGroup.conditions) &&
        Objects.equals(this.limit, conditionalGroup.limit);
  }

  @Override
  public int hashCode() {
    return Objects.hash(description, conditions, limit);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ConditionalGroup {\n");
    
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    conditions: ").append(toIndentedString(conditions)).append("\n");
    sb.append("    limit: ").append(toIndentedString(limit)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

