/*
 * WSO2 API Manager - Admin
 * This document specifies a **RESTful API** for WSO2 **API Manager** - Admin Portal. Please see [full swagger definition](https://raw.githubusercontent.com/wso2/carbon-apimgt/v6.1.66/components/apimgt/org.wso2.carbon.apimgt.rest.api.admin/src/main/resources/admin-api.yaml) of the API which is written using [swagger 2.0](http://swagger.io/) specification. 
 *
 * OpenAPI spec version: 0.11.0
 * Contact: architecture@wso2.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.wso2.carbon.apimgt.samples.utils.admin.rest.client.model;

import java.util.Objects;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.wso2.carbon.apimgt.samples.utils.admin.rest.client.model.ThrottlePolicy;

/**
 * CustomRule
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2017-11-01T13:06:20.200+05:30")
public class CustomRule {
  @SerializedName("policyId")
  private String policyId = null;

  @SerializedName("policyName")
  private String policyName = null;

  @SerializedName("displayName")
  private String displayName = null;

  @SerializedName("description")
  private String description = null;

  @SerializedName("isDeployed")
  private Boolean isDeployed = false;

  @SerializedName("siddhiQuery")
  private String siddhiQuery = null;

  @SerializedName("keyTemplate")
  private String keyTemplate = null;

  public CustomRule policyId(String policyId) {
    this.policyId = policyId;
    return this;
  }

   /**
   * Id of policy
   * @return policyId
  **/
  @ApiModelProperty(example = "0c6439fd-9b16-3c2e-be6e-1086e0b9aa93", value = "Id of policy")
  public String getPolicyId() {
    return policyId;
  }

  public void setPolicyId(String policyId) {
    this.policyId = policyId;
  }

  public CustomRule policyName(String policyName) {
    this.policyName = policyName;
    return this;
  }

   /**
   * Name of policy
   * @return policyName
  **/
  @ApiModelProperty(example = "Policy1", required = true, value = "Name of policy")
  public String getPolicyName() {
    return policyName;
  }

  public void setPolicyName(String policyName) {
    this.policyName = policyName;
  }

  public CustomRule displayName(String displayName) {
    this.displayName = displayName;
    return this;
  }

   /**
   * Display name of the policy
   * @return displayName
  **/
  @ApiModelProperty(example = "null", value = "Display name of the policy")
  public String getDisplayName() {
    return displayName;
  }

  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }

  public CustomRule description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Description of the policy
   * @return description
  **/
  @ApiModelProperty(example = "null", value = "Description of the policy")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public CustomRule isDeployed(Boolean isDeployed) {
    this.isDeployed = isDeployed;
    return this;
  }

   /**
   * Indicates whether the policy is deployed successfully or not.
   * @return isDeployed
  **/
  @ApiModelProperty(example = "null", value = "Indicates whether the policy is deployed successfully or not.")
  public Boolean getIsDeployed() {
    return isDeployed;
  }

  public void setIsDeployed(Boolean isDeployed) {
    this.isDeployed = isDeployed;
  }

  public CustomRule siddhiQuery(String siddhiQuery) {
    this.siddhiQuery = siddhiQuery;
    return this;
  }

   /**
   * Siddhi query which represents the custom throttling policy
   * @return siddhiQuery
  **/
  @ApiModelProperty(example = "", value = "Siddhi query which represents the custom throttling policy")
  public String getSiddhiQuery() {
    return siddhiQuery;
  }

  public void setSiddhiQuery(String siddhiQuery) {
    this.siddhiQuery = siddhiQuery;
  }

  public CustomRule keyTemplate(String keyTemplate) {
    this.keyTemplate = keyTemplate;
    return this;
  }

   /**
   * The specific combination of attributes that are checked in the policy.
   * @return keyTemplate
  **/
  @ApiModelProperty(example = "$userId", value = "The specific combination of attributes that are checked in the policy.")
  public String getKeyTemplate() {
    return keyTemplate;
  }

  public void setKeyTemplate(String keyTemplate) {
    this.keyTemplate = keyTemplate;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CustomRule customRule = (CustomRule) o;
    return Objects.equals(this.policyId, customRule.policyId) &&
        Objects.equals(this.policyName, customRule.policyName) &&
        Objects.equals(this.displayName, customRule.displayName) &&
        Objects.equals(this.description, customRule.description) &&
        Objects.equals(this.isDeployed, customRule.isDeployed) &&
        Objects.equals(this.siddhiQuery, customRule.siddhiQuery) &&
        Objects.equals(this.keyTemplate, customRule.keyTemplate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(policyId, policyName, displayName, description, isDeployed, siddhiQuery, keyTemplate);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CustomRule {\n");
    
    sb.append("    policyId: ").append(toIndentedString(policyId)).append("\n");
    sb.append("    policyName: ").append(toIndentedString(policyName)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    isDeployed: ").append(toIndentedString(isDeployed)).append("\n");
    sb.append("    siddhiQuery: ").append(toIndentedString(siddhiQuery)).append("\n");
    sb.append("    keyTemplate: ").append(toIndentedString(keyTemplate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

