/*
 * WSO2 API Manager - Publisher API
 * This specifies a **RESTful API** for WSO2 **API Manager** - Publisher.  Please see [full swagger definition](https://raw.githubusercontent.com/wso2/carbon-apimgt/v6.1.66/components/apimgt/org.wso2.carbon.apimgt.rest.api.publisher/src/main/resources/publisher-api.yaml) of the API which is written using [swagger 2.0](http://swagger.io/) specification. 
 *
 * OpenAPI spec version: 0.11.0
 * Contact: architecture@wso2.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.api;

import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ApiCallback;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ApiClient;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ApiException;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ApiResponse;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.Configuration;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.Pair;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ProgressRequestBody;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.model.Error;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.model.Workflow;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WorkflowsIndividualApi {
    private ApiClient apiClient;

    public WorkflowsIndividualApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WorkflowsIndividualApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /* Build call for workflowsUpdateWorkflowStatusPost */
    private com.squareup.okhttp.Call workflowsUpdateWorkflowStatusPostCall(String workflowReferenceId, Workflow body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        
        // create path and map variables
        String localVarPath = "/workflows/update-workflow-status".replaceAll("\\{format\\}","json");

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (workflowReferenceId != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "workflowReferenceId", workflowReferenceId));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call workflowsUpdateWorkflowStatusPostValidateBeforeCall(String workflowReferenceId, Workflow body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'workflowReferenceId' is set
        if (workflowReferenceId == null) {
            throw new ApiException("Missing the required parameter 'workflowReferenceId' when calling workflowsUpdateWorkflowStatusPost(Async)");
        }
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling workflowsUpdateWorkflowStatusPost(Async)");
        }
        
        
        com.squareup.okhttp.Call call = workflowsUpdateWorkflowStatusPostCall(workflowReferenceId, body, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Update workflow status
     * This operation can be used to approve or reject a workflow task. 
     * @param workflowReferenceId Workflow reference id  (required)
     * @param body Workflow event that need to be updated  (required)
     * @return Workflow
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Workflow workflowsUpdateWorkflowStatusPost(String workflowReferenceId, Workflow body) throws ApiException {
        ApiResponse<Workflow> resp = workflowsUpdateWorkflowStatusPostWithHttpInfo(workflowReferenceId, body);
        return resp.getData();
    }

    /**
     * Update workflow status
     * This operation can be used to approve or reject a workflow task. 
     * @param workflowReferenceId Workflow reference id  (required)
     * @param body Workflow event that need to be updated  (required)
     * @return ApiResponse&lt;Workflow&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Workflow> workflowsUpdateWorkflowStatusPostWithHttpInfo(String workflowReferenceId, Workflow body) throws ApiException {
        com.squareup.okhttp.Call call = workflowsUpdateWorkflowStatusPostValidateBeforeCall(workflowReferenceId, body, null, null);
        Type localVarReturnType = new TypeToken<Workflow>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Update workflow status (asynchronously)
     * This operation can be used to approve or reject a workflow task. 
     * @param workflowReferenceId Workflow reference id  (required)
     * @param body Workflow event that need to be updated  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call workflowsUpdateWorkflowStatusPostAsync(String workflowReferenceId, Workflow body, final ApiCallback<Workflow> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = workflowsUpdateWorkflowStatusPostValidateBeforeCall(workflowReferenceId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Workflow>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
