/*
 * WSO2 API Manager - Store
 * This specifies a **RESTful API** for WSO2 **API Manager** - Store.  Please see [full swagger definition](https://raw.githubusercontent.com/wso2/carbon-apimgt/v6.1.66/components/apimgt/org.wso2.carbon.apimgt.rest.api.store/src/main/resources/store-api.yaml) of the API which is written using [swagger 2.0](http://swagger.io/) specification. 
 *
 * OpenAPI spec version: 0.11.0
 * Contact: architecture@wso2.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.wso2.carbon.apimgt.samples.utils.store.rest.client.model;

import java.util.Objects;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;

/**
 * ApplicationKeyGenerateRequest
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2017-11-01T12:42:08.204+05:30")
public class ApplicationKeyGenerateRequest {
  /**
   * Gets or Sets keyType
   */
  public enum KeyTypeEnum {
    @SerializedName("PRODUCTION")
    PRODUCTION("PRODUCTION"),
    
    @SerializedName("SANDBOX")
    SANDBOX("SANDBOX");

    private String value;

    KeyTypeEnum(String value) {
      this.value = value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
  }

  @SerializedName("keyType")
  private KeyTypeEnum keyType = null;

  @SerializedName("validityTime")
  private String validityTime = null;

  @SerializedName("supportedGrantTypes")
  private List<String> supportedGrantTypes = new ArrayList<String>();

  @SerializedName("callbackUrl")
  private String callbackUrl = null;

  @SerializedName("accessAllowDomains")
  private List<String> accessAllowDomains = new ArrayList<String>();

  @SerializedName("scopes")
  private List<String> scopes = new ArrayList<String>();

  public ApplicationKeyGenerateRequest keyType(KeyTypeEnum keyType) {
    this.keyType = keyType;
    return this;
  }

   /**
   * Get keyType
   * @return keyType
  **/
  @ApiModelProperty(example = "PRODUCTION", required = true, value = "")
  public KeyTypeEnum getKeyType() {
    return keyType;
  }

  public void setKeyType(KeyTypeEnum keyType) {
    this.keyType = keyType;
  }

  public ApplicationKeyGenerateRequest validityTime(String validityTime) {
    this.validityTime = validityTime;
    return this;
  }

   /**
   * Get validityTime
   * @return validityTime
  **/
  @ApiModelProperty(example = "3600", required = true, value = "")
  public String getValidityTime() {
    return validityTime;
  }

  public void setValidityTime(String validityTime) {
    this.validityTime = validityTime;
  }

  public ApplicationKeyGenerateRequest supportedGrantTypes(List<String> supportedGrantTypes) {
    this.supportedGrantTypes = supportedGrantTypes;
    return this;
  }

  public ApplicationKeyGenerateRequest addSupportedGrantTypesItem(String supportedGrantTypesItem) {
    this.supportedGrantTypes.add(supportedGrantTypesItem);
    return this;
  }

   /**
   * The grant types that are supported by the application
   * @return supportedGrantTypes
  **/
  @ApiModelProperty(example = "[&quot;client_credentials&quot;,&quot;password&quot;]", value = "The grant types that are supported by the application")
  public List<String> getSupportedGrantTypes() {
    return supportedGrantTypes;
  }

  public void setSupportedGrantTypes(List<String> supportedGrantTypes) {
    this.supportedGrantTypes = supportedGrantTypes;
  }

  public ApplicationKeyGenerateRequest callbackUrl(String callbackUrl) {
    this.callbackUrl = callbackUrl;
    return this;
  }

   /**
   * Callback URL
   * @return callbackUrl
  **/
  @ApiModelProperty(example = "", value = "Callback URL")
  public String getCallbackUrl() {
    return callbackUrl;
  }

  public void setCallbackUrl(String callbackUrl) {
    this.callbackUrl = callbackUrl;
  }

  public ApplicationKeyGenerateRequest accessAllowDomains(List<String> accessAllowDomains) {
    this.accessAllowDomains = accessAllowDomains;
    return this;
  }

  public ApplicationKeyGenerateRequest addAccessAllowDomainsItem(String accessAllowDomainsItem) {
    this.accessAllowDomains.add(accessAllowDomainsItem);
    return this;
  }

   /**
   * Allowed domains for the access token
   * @return accessAllowDomains
  **/
  @ApiModelProperty(example = "[&quot;ALL&quot;]", required = true, value = "Allowed domains for the access token")
  public List<String> getAccessAllowDomains() {
    return accessAllowDomains;
  }

  public void setAccessAllowDomains(List<String> accessAllowDomains) {
    this.accessAllowDomains = accessAllowDomains;
  }

  public ApplicationKeyGenerateRequest scopes(List<String> scopes) {
    this.scopes = scopes;
    return this;
  }

  public ApplicationKeyGenerateRequest addScopesItem(String scopesItem) {
    this.scopes.add(scopesItem);
    return this;
  }

   /**
   * Allowed scopes for the access token
   * @return scopes
  **/
  @ApiModelProperty(example = "[&quot;am_application_scope&quot;,&quot;default&quot;]", value = "Allowed scopes for the access token")
  public List<String> getScopes() {
    return scopes;
  }

  public void setScopes(List<String> scopes) {
    this.scopes = scopes;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApplicationKeyGenerateRequest applicationKeyGenerateRequest = (ApplicationKeyGenerateRequest) o;
    return Objects.equals(this.keyType, applicationKeyGenerateRequest.keyType) &&
        Objects.equals(this.validityTime, applicationKeyGenerateRequest.validityTime) &&
        Objects.equals(this.supportedGrantTypes, applicationKeyGenerateRequest.supportedGrantTypes) &&
        Objects.equals(this.callbackUrl, applicationKeyGenerateRequest.callbackUrl) &&
        Objects.equals(this.accessAllowDomains, applicationKeyGenerateRequest.accessAllowDomains) &&
        Objects.equals(this.scopes, applicationKeyGenerateRequest.scopes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(keyType, validityTime, supportedGrantTypes, callbackUrl, accessAllowDomains, scopes);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApplicationKeyGenerateRequest {\n");
    
    sb.append("    keyType: ").append(toIndentedString(keyType)).append("\n");
    sb.append("    validityTime: ").append(toIndentedString(validityTime)).append("\n");
    sb.append("    supportedGrantTypes: ").append(toIndentedString(supportedGrantTypes)).append("\n");
    sb.append("    callbackUrl: ").append(toIndentedString(callbackUrl)).append("\n");
    sb.append("    accessAllowDomains: ").append(toIndentedString(accessAllowDomains)).append("\n");
    sb.append("    scopes: ").append(toIndentedString(scopes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

