/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.extension.siddhi.execution.time;

import java.util.Map;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.ReturnAttribute;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

@Extension(name="concat", namespace="str", description="description", parameters={@Parameter(name="string.1", description="The batch time period for which the window should hold events.", type={DataType.INT, DataType.LONG, DataType.TIME}), @Parameter(name="string.2", description="This specifies an offset in milliseconds in order to start the window at a time different to the standard time.", type={DataType.STRING})}, returnAttributes={@ReturnAttribute(description="Returned type will be defined by the cast.to string constant value.", type={DataType.STRING})}, examples={@Example(syntax="define window cseEventWindow (symbol string, price float, volume int) timeBatch(20) output all events;\n@info(name = 'query0')\nfrom cseEventStream\ninsert into cseEventWindow;\n@info(name = 'query1')\nfrom cseEventWindow\nselect symbol, sum(price) as price\ninsert all events into outputStream ;", description="This will processing events arrived every 20 milliseconds as a batch and out put all events.")})
public class ConcatFunctionExtension
extends FunctionExecutor {
    private Attribute.Type returnType = Attribute.Type.STRING;

    protected void init(ExpressionExecutor[] expressionExecutors, ConfigReader configReader, ExecutionPlanContext executionPlanContext) {
        if (this.attributeExpressionExecutors.length < 2) {
            throw new ExecutionPlanValidationException("str:concat() function requires at least two arguments, but found only " + this.attributeExpressionExecutors.length);
        }
    }

    protected Object execute(Object[] data) {
        StringBuilder sb = new StringBuilder();
        for (Object aData : data) {
            if (aData == null) continue;
            sb.append(aData);
        }
        return sb.toString();
    }

    protected Object execute(Object data) {
        return data;
    }

    public void start() {
    }

    public void stop() {
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    public Map<String, Object> currentState() {
        return null;
    }

    public void restoreState(Map<String, Object> map) {
    }
}

