/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.extension.siddhi.execution.time;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.exception.ExecutionPlanRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class DateFormatFunctionExtension
extends FunctionExecutor {
    private Attribute.Type returnType = Attribute.Type.STRING;
    private static final Logger log = Logger.getLogger(DateFormatFunctionExtension.class);
    private boolean useDefaultDateFormat = false;
    private String sourceDateFormat = null;
    private Calendar calInstance = Calendar.getInstance();

    protected void init(ExpressionExecutor[] expressionExecutors, ConfigReader configReader, ExecutionPlanContext executionPlanContext) {
        if (this.attributeExpressionExecutors[0].getReturnType() != Attribute.Type.LONG && this.attributeExpressionExecutors.length == 2) {
            this.useDefaultDateFormat = true;
            this.sourceDateFormat = "yyyy-MM-dd HH:mm:ss.SSS";
        }
        if (this.attributeExpressionExecutors.length == 3) {
            if (this.attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
                throw new ExecutionPlanValidationException("Invalid parameter type found for the first argument of time:dateFormat(dateValue,dateTargetFormat,dateSourceFormat) function, required " + Attribute.Type.STRING + " but found " + this.attributeExpressionExecutors[0].getReturnType().toString());
            }
            if (this.attributeExpressionExecutors[1].getReturnType() != Attribute.Type.STRING) {
                throw new ExecutionPlanValidationException("Invalid parameter type found for the second argument of time:dateFormat(dateValue,dateTargetFormat,dateSourceFormat) function, required " + Attribute.Type.STRING + " but found " + this.attributeExpressionExecutors[1].getReturnType().toString());
            }
            if (this.attributeExpressionExecutors[2].getReturnType() != Attribute.Type.STRING) {
                throw new ExecutionPlanValidationException("Invalid parameter type found for the third argument of time:dateFormat(dateValue,dateTargetFormat,dateSourceFormat) function, required " + Attribute.Type.STRING + " but found " + this.attributeExpressionExecutors[2].getReturnType().toString());
            }
        } else if (this.attributeExpressionExecutors.length == 2) {
            if (this.useDefaultDateFormat) {
                if (this.attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
                    throw new ExecutionPlanValidationException("Invalid parameter type found for the first argument of time:dateFormat(dateValue,dateTargetFormat,dateSourceFormat) function, required " + Attribute.Type.STRING + " but found " + this.attributeExpressionExecutors[0].getReturnType().toString());
                }
                if (this.attributeExpressionExecutors[1].getReturnType() != Attribute.Type.STRING) {
                    throw new ExecutionPlanValidationException("Invalid parameter type found for the second argument of time:dateFormat(dateValue,dateTargetFormat,dateSourceFormat) function, required " + Attribute.Type.STRING + " but found " + this.attributeExpressionExecutors[1].getReturnType().toString());
                }
            } else {
                if (this.attributeExpressionExecutors[0].getReturnType() != Attribute.Type.LONG) {
                    throw new ExecutionPlanValidationException("Invalid parameter type found for the first argument of time:dateFormat(timestampInMilliseconds,dateTargetFormat) function, required " + Attribute.Type.LONG + " but found " + this.attributeExpressionExecutors[0].getReturnType().toString());
                }
                if (this.attributeExpressionExecutors[1].getReturnType() != Attribute.Type.STRING) {
                    throw new ExecutionPlanValidationException("Invalid parameter type found for the second argument of time:dateFormat(timestampInMilliseconds,dateTargetFormat) function, required " + Attribute.Type.STRING + " but found " + this.attributeExpressionExecutors[1].getReturnType().toString());
                }
            }
        } else {
            throw new ExecutionPlanValidationException("Invalid no of arguments passed to dateFormat() function, required 2 or 3, but found " + this.attributeExpressionExecutors.length);
        }
    }

    protected Object execute(Object[] data) {
        if (data.length == 3 || this.useDefaultDateFormat) {
            String sourceDate = null;
            try {
                if (data[0] == null) {
                    throw new ExecutionPlanRuntimeException("Invalid input given to time:dateFormat(dateValue,dateTargetFormat,dateSourceFormat) function. First argument cannot be null");
                }
                if (data[1] == null) {
                    throw new ExecutionPlanRuntimeException("Invalid input given to time:dateFormat(dateValue,dateTargetFormat,dateSourceFormat) function. Second argument cannot be null");
                }
                if (!this.useDefaultDateFormat) {
                    if (data[2] == null) {
                        throw new ExecutionPlanRuntimeException("Invalid input given to time:dateFormat(dateValue,dateTargetFormat,dateSourceFormat) function. Third argument cannot be null");
                    }
                    this.sourceDateFormat = (String)data[2];
                }
                sourceDate = (String)data[0];
                String targetDataFormat = (String)data[1];
                FastDateFormat userSpecifiedSourceFormat = FastDateFormat.getInstance(this.sourceDateFormat);
                Date userSpecifiedSourceDate = userSpecifiedSourceFormat.parse(sourceDate);
                FastDateFormat targetFormat = FastDateFormat.getInstance(targetDataFormat);
                return targetFormat.format(userSpecifiedSourceDate);
            }
            catch (ParseException e) {
                String errorMsg = "Provided format " + this.sourceDateFormat + " does not match with the timestamp " + sourceDate + " " + e.getMessage();
                throw new ExecutionPlanRuntimeException(errorMsg, (Throwable)e);
            }
            catch (ClassCastException e) {
                String errorMsg = "Provided Data type cannot be cast to desired format. " + e.getMessage();
                throw new ExecutionPlanRuntimeException(errorMsg, (Throwable)e);
            }
        }
        if (data.length == 2) {
            if (data[0] == null) {
                throw new ExecutionPlanRuntimeException("Invalid input given to dateFormat(timestampInMilliseconds,dateTargetFormat) function. First argument cannot be null");
            }
            if (data[1] == null) {
                throw new ExecutionPlanRuntimeException("Invalid input given to dateFormat(timestampInMilliseconds,dateTargetFormat) function. Second argument cannot be null");
            }
            try {
                String targetDataFormat = (String)data[1];
                FastDateFormat targetFormat = FastDateFormat.getInstance(targetDataFormat);
                long dateInMills = (Long)data[0];
                this.calInstance.setTimeInMillis(dateInMills);
                Date userSpecifiedSourceDate = this.calInstance.getTime();
                String formattedNewDateValue = targetFormat.format(userSpecifiedSourceDate);
                return formattedNewDateValue;
            }
            catch (ClassCastException e) {
                String errorMsg = "Provided Data type cannot be cast to desired format. " + e.getMessage();
                throw new ExecutionPlanRuntimeException(errorMsg, (Throwable)e);
            }
        }
        throw new ExecutionPlanRuntimeException("Invalid set of arguments given to time:dateFormat() function.Arguments should be either 2 or 3. ");
    }

    protected Object execute(Object data) {
        return null;
    }

    public void start() {
    }

    public void stop() {
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    public Map<String, Object> currentState() {
        return new HashMap<String, Object>();
    }

    public void restoreState(Map<String, Object> map) {
    }
}

