/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.extension.siddhi.execution.time;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.exception.ExecutionPlanRuntimeException;
import org.wso2.siddhi.core.exception.OperationNotSupportedException;
import org.wso2.siddhi.core.executor.ConstantExpressionExecutor;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class DateSubFunctionExtension
extends FunctionExecutor {
    private Attribute.Type returnType = Attribute.Type.STRING;
    private static final Logger log = Logger.getLogger(DateSubFunctionExtension.class);
    private boolean useDefaultDateFormat = false;
    private String dateFormat = null;
    private Calendar calInstance = Calendar.getInstance();
    private String unit = null;

    protected void init(ExpressionExecutor[] expressionExecutors, ConfigReader configReader, ExecutionPlanContext executionPlanContext) {
        if (this.attributeExpressionExecutors[0].getReturnType() != Attribute.Type.LONG && this.attributeExpressionExecutors.length == 3) {
            this.useDefaultDateFormat = true;
            this.dateFormat = "yyyy-MM-dd HH:mm:ss.SSS";
        }
        if (this.attributeExpressionExecutors.length == 4) {
            if (this.attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
                throw new ExecutionPlanValidationException("Invalid parameter type found for the first argument of time:dateSub(dateValue,expr,unit,dateFormat) function, required " + Attribute.Type.STRING + " but found " + this.attributeExpressionExecutors[0].getReturnType().toString());
            }
            if (this.attributeExpressionExecutors[1].getReturnType() != Attribute.Type.INT) {
                throw new ExecutionPlanValidationException("Invalid parameter type found for the second argument of time:dateSub(dateValue,expr,unit,dateFormat) function, required " + Attribute.Type.INT + " but found " + this.attributeExpressionExecutors[1].getReturnType().toString());
            }
            if (this.attributeExpressionExecutors[2].getReturnType() != Attribute.Type.STRING) {
                throw new ExecutionPlanValidationException("Invalid parameter type found for the third argument of time:dateSub(dateValue,expr,unit,dateFormat) function, required " + Attribute.Type.STRING + " but found " + this.attributeExpressionExecutors[2].getReturnType().toString());
            }
            if (this.attributeExpressionExecutors[3].getReturnType() != Attribute.Type.STRING) {
                throw new ExecutionPlanValidationException("Invalid parameter type found for the fourth argument of time:dateSub(dateValue,expr,unit,dateFormat) function, required " + Attribute.Type.STRING + " but found " + this.attributeExpressionExecutors[3].getReturnType().toString());
            }
        } else if (this.attributeExpressionExecutors.length == 3) {
            if (this.useDefaultDateFormat) {
                if (this.attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
                    throw new ExecutionPlanValidationException("Invalid parameter type found for the first argument of time:dateSub(dateValue,expr,unit) function, required " + Attribute.Type.STRING + " but found " + this.attributeExpressionExecutors[0].getReturnType().toString());
                }
                if (this.attributeExpressionExecutors[1].getReturnType() != Attribute.Type.INT) {
                    throw new ExecutionPlanValidationException("Invalid parameter type found for the second argument of time:dateSub(dateValue,expr,unit) function, required " + Attribute.Type.INT + " but found " + this.attributeExpressionExecutors[1].getReturnType().toString());
                }
                if (this.attributeExpressionExecutors[2].getReturnType() != Attribute.Type.STRING) {
                    throw new ExecutionPlanValidationException("Invalid parameter type found for the second argument of time:dateSub(dateValue,expr,unit) function, required " + Attribute.Type.STRING + " but found " + this.attributeExpressionExecutors[2].getReturnType().toString());
                }
            } else {
                if (this.attributeExpressionExecutors[0].getReturnType() != Attribute.Type.LONG) {
                    throw new ExecutionPlanValidationException("Invalid parameter type found for the first argument of time:dateSub(timestampInMilliseconds,expr,unit) function, required " + Attribute.Type.LONG + " but found " + this.attributeExpressionExecutors[0].getReturnType().toString());
                }
                if (this.attributeExpressionExecutors[1].getReturnType() != Attribute.Type.INT) {
                    throw new ExecutionPlanValidationException("Invalid parameter type found for the second argument of time:dateSub(timestampInMilliseconds,expr,unit) function, required " + Attribute.Type.INT + " but found " + this.attributeExpressionExecutors[1].getReturnType().toString());
                }
                if (this.attributeExpressionExecutors[2].getReturnType() != Attribute.Type.STRING) {
                    throw new ExecutionPlanValidationException("Invalid parameter type found for the second argument of time:dateSub(timestampInMilliseconds,expr,unit) function, required " + Attribute.Type.STRING + " but found " + this.attributeExpressionExecutors[2].getReturnType().toString());
                }
            }
        } else {
            throw new ExecutionPlanValidationException("Invalid no of arguments passed to time:dateSub() function, required 3 or 4, but found " + this.attributeExpressionExecutors.length);
        }
        if (!(this.attributeExpressionExecutors[2] instanceof ConstantExpressionExecutor)) {
            throw new OperationNotSupportedException("unit value has to be a constant");
        }
        this.unit = ((String)((ConstantExpressionExecutor)this.attributeExpressionExecutors[2]).getValue()).toUpperCase();
    }

    protected Object execute(Object[] data) {
        String date = null;
        if (data.length == 4 || this.useDefaultDateFormat) {
            try {
                if (data[0] == null) {
                    throw new ExecutionPlanRuntimeException("Invalid input given to str:dateSub(date,expr,unit,dateFormat) function. First argument cannot be null");
                }
                if (data[1] == null) {
                    throw new ExecutionPlanRuntimeException("Invalid input given to str:dateSub(date,expr,unit,dateFormat) function. Second argument cannot be null");
                }
                if (!this.useDefaultDateFormat) {
                    if (data[3] == null) {
                        throw new ExecutionPlanRuntimeException("Invalid input given to str:dateSub(date,expr,unit,dateFormat) function. Fourth argument cannot be null");
                    }
                    this.dateFormat = (String)data[3];
                }
                date = (String)data[0];
                int expression = (Integer)data[1];
                expression = -expression;
                FastDateFormat formattedDate = FastDateFormat.getInstance(this.dateFormat);
                Date userSpecifiedDate = formattedDate.parse(date);
                this.calInstance.setTime(userSpecifiedDate);
                this.getProcessedCalenderInstance(this.unit, this.calInstance, expression);
                return formattedDate.format(this.calInstance.getTime());
            }
            catch (ParseException e) {
                String errorMsg = "Provided format " + this.dateFormat + " does not match with the timestamp " + date + e.getMessage();
                throw new ExecutionPlanRuntimeException(errorMsg, (Throwable)e);
            }
            catch (ClassCastException e) {
                String errorMsg = "Provided Data type cannot be cast to desired format. " + e.getMessage();
                throw new ExecutionPlanRuntimeException(errorMsg, (Throwable)e);
            }
        }
        if (data.length == 3) {
            if (data[0] == null) {
                throw new ExecutionPlanRuntimeException("Invalid input given to time:dateSub(timestampInMilliseconds,expr,unit) function. First argument cannot be null");
            }
            if (data[1] == null) {
                throw new ExecutionPlanRuntimeException("Invalid input given to time:dateSub(timestampInMilliseconds,expr,unit) function. Second argument cannot be null");
            }
            if (data[2] == null) {
                throw new ExecutionPlanRuntimeException("Invalid input given to time:dateSub(timestampInMilliseconds,expr,unit) function. Third argument cannot be null");
            }
            try {
                long dateInMills = (Long)data[0];
                this.calInstance.setTimeInMillis(dateInMills);
                int expression = (Integer)data[1];
                expression = -expression;
                this.getProcessedCalenderInstance(this.unit, this.calInstance, expression);
                return String.valueOf(this.calInstance.getTimeInMillis());
            }
            catch (ClassCastException e) {
                String errorMsg = "Provided Data type cannot be cast to desired format. " + e.getMessage();
                throw new ExecutionPlanRuntimeException(errorMsg, (Throwable)e);
            }
        }
        throw new ExecutionPlanRuntimeException("Invalid set of arguments given to time:dateSub() function.Arguments should be either 3 or 4. ");
    }

    private Calendar getProcessedCalenderInstance(String unit, Calendar calInstance, int expression) {
        if (unit.equals("YEAR")) {
            calInstance.add(1, expression);
        } else if (unit.equals("MONTH")) {
            calInstance.add(2, expression);
        } else if (unit.equals("SECOND")) {
            calInstance.add(13, expression);
        } else if (unit.equals("MINUTE")) {
            calInstance.add(12, expression);
        } else if (unit.equals("HOUR")) {
            calInstance.add(10, expression);
        } else if (unit.equals("DAY")) {
            calInstance.add(5, expression);
        } else if (unit.equals("WEEK")) {
            calInstance.add(3, expression);
        } else if (unit.equals("QUARTER")) {
            calInstance.add(2, expression * 3);
        }
        return calInstance;
    }

    protected Object execute(Object data) {
        return null;
    }

    public void start() {
    }

    public void stop() {
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    public Map<String, Object> currentState() {
        return new HashMap<String, Object>();
    }

    public void restoreState(Map<String, Object> map) {
    }
}

